class Thing
{
  double tx, ty, w, h, multiplier;
  double previousx, previousy, previouswidth, previousheight;
  Rectangle boundbox;
  boolean movable;
  boolean passable;
  boolean hurts;
  int damage;
  double danielx;
  double daniely;
  double danielw;
  double danielh;
  
  Thing(double ux, double uy, double uw, double uh, double m)
  {
    multiplier = m;
    tx= multiplier*ux;
    ty = multiplier*uy;
    w= multiplier*uw;
    h = multiplier*uh;
    danielx= ux;
    daniely= uy;
    danielw= uw;
    danielh= uh;
    previousx = tx;
    previousy = ty;
    previouswidth = w;
    previousheight = h;
    boundbox = new Rectangle(tx,  ty,  w,  h);
    passable = true;
    movable = false;
    hurts = false;
    damage = 0;
  }
  
  String getType()
  {
   return("Thing"); 
  }
  
  void drawSelf()
  {
    fill(206, 226, 44);
    rect((int)tx, (int) ty, (int) w, (int) h);
  }
  
  void changeX(double ix)
  {
    setX(tx + ix);
  }
  
  double getX()
  {
    return tx;
  }
  
  void setX(double ix)
  {
    tx = ix;
    boundbox.setLocation(tx, ty);
  }
  
  void changeY(double iy)
  {
    setY(ty + iy);
  }
  
  double getY()
  {
    return ty;
  }
  
  void setY(double iy)
  {
    ty = iy;
    boundbox.setLocation(tx, ty);
  }
  
  double getWidth()
  {
    return w;
  }
  
  void setWidth(double iw)
  {
    w = iw;
    boundbox.setWidth(iw);
  }
  
  void changeWidth(double iw)
  {
    setWidth(w + iw);
  }
  
  double getHeight()
  {
    return h;
  }
  
  void setHeight(double ih)
  {
    h = ih;
    boundbox.setHeight(ih);
  }
  
  void changeHeight(double ih)
  {
    setHeight(h + ih);
  }
  
  Rectangle getBox()
  {
    return boundbox;
  }
  
  double getMultiplier()
  {
   return multiplier; 
  }
  
  boolean getMovable()
  {
    return movable;
  }
  
  void setMovable(boolean b)
  {
    movable = b;
  }
  
  boolean getPassable()
  {
   return passable; 
  }
  
  void setPassable(boolean b)
  {
    passable = b;
  }
  
  double getPreviousX()
  {
   return previousx; 
  }
  
  double getPreviousY()
  {
   return previousy; 
  }
  
  double getPreviousWidth()
  {
    return previouswidth;
  }
  
  double getPreviousHeight()
  {
    return previousheight;
  }
  
  void validateMove()
  {
    previousx = tx;
    previousy = ty;
    previouswidth = w;
    previousheight = h;
  }
  
  void resetPosition()
  {
    setX(previousx);
    setY(previousy);
   // println("Forced to reset on account of collision");
    //setWidth(previouswidth);
    //setHeight(previousheight);
  }
  
  boolean getHurts()
  {
   return hurts; 
  }
  
  void setHurts(boolean b)
  {
   hurts = b; 
  }
  
  int getDamage()
  {
   return damage; 
  }
  
  void setDamage(int i)
  {
   damage = i; 
  }
  
  double getDanielX()
  {
   return tx/multiplier; 
  }
  
  double getDanielY()
  {
   return ty/multiplier; 
  }
  
  double getDanielWidth()
  {
   return danielw; 
  }
  
  double getDanielHeight()
  {
   return danielh; 
  }
  
  
}
