class TwitterDungeonBuilder extends DungeonBuilder
{

  Dungeon bird;
  URL url;
  HttpURLConnection urlconnection;
  InputStream in;
  BufferedReader r;
  StringBuilder total ;
  String line;
  String firsttweet="NO WORK";
  int angrycounter=0;
  double angrycoefficient;
  int angrymultiplier;

  TwitterDungeonBuilder()
  {
    bird = new Dungeon(4, 4);
    //    background(200, 93, 122);
    //    fill(19, 100, 158);
    //    rect(width/2, height/2, 10, 10);

    try
    {
      url= new URL("http://search.twitter.com/search.json?q=games");
      urlconnection= (HttpURLConnection) url.openConnection();
      in= new BufferedInputStream(urlconnection.getInputStream());
      r = new BufferedReader(new InputStreamReader(in));
      total = new StringBuilder();

      while ( (line = r.readLine ()) != null) 
      {
        total.append(line);
      }
      firsttweet=total.toString();
    }
    catch(Exception e)
    {
      println("Caught an exception: " + e.getMessage());
    }

    int startindex= firsttweet.indexOf("text")+7;
    int endindex=   firsttweet.indexOf("\",\"to_user\"");

    firsttweet = firsttweet.substring(startindex, endindex);

    char charmander;

    //              _.--""`-..
    //            ,'          `.
    //          ,'          __  `.
    //         /|          " __   \
    //        , |           / |.   .
    //        |,'          !_.'|   |
    //      ,'             '   |   |
    //     /              |`--'|   |
    //    |                `---'   |
    //     .   ,                   |                       ,".
    //      ._     '           _'  |                    , ' \ `
    //  `.. `.`-...___,...---""    |       __,.        ,`"   L,|
    //  |, `- .`._        _,-,.'   .  __.-'-. /        .   ,    \
    //-:..     `. `-..--_.,.<       `"      / `.        `-/ |   .
    //  `,         """"'     `.              ,'         |   |  ',,
    //    `.      '            '            /          '    |'. |/
    //      `.   |              \       _,-'           |       ''
    //        `._'               \   '"\                .      |
    //           |                '     \                `._  ,'
    //           |                 '     \                 .'|
    //           |                 .      \                | |
    //           |                 |       L              ,' |
    //           `                 |       |             /   '
    //            \                |       |           ,'   /
    //          ,' \               |  _.._ ,-..___,..-'    ,'
    //         /     .             .      `!             ,j'
    //        /       `.          /        .           .'/
    //       .          `.       /         |        _.'.'
    //        `.          7`'---'          |------"'_.'
    //       _,.`,_     _'                ,''-----"'
    //   _,-_    '       `.     .'      ,\
    //   -" /`.         _,'     | _  _  _.|
    //    ""--'---"""""'        `' '! |! /
    //                            `" " -' mh




    for (int x = 0; x < firsttweet.length(); x++)
    {
      println("Incrementing!");
      charmander = firsttweet.charAt(x);
      println(charmander);
      if (charmander == '@')
      {
        println("Decrementing angrycounter");
        angrycounter--;
      }
      else if (charmander == '!')
      {
        angrycounter+=2;
      }
      else if (!(charmander == ' ' || charmander == 'a' || charmander=='e' || charmander=='i' || charmander == 'o' || charmander=='u'))
      {
        println("Incrementing angrycounter");
        angrycounter++;
      }
    }

    println(firsttweet);
    println("Length: "+ firsttweet.length());
    println("angrycounter: " + angrycounter);
    println("Angry coefficient: " + ((double)angrycounter)/ (double) firsttweet.length());
    angrycoefficient= (((double)angrycounter)/ (double) firsttweet.length())  * 100;
    angrymultiplier = (int)(angrycoefficient*10)%((int)angrycoefficient);
    if (angrymultiplier <= 0)
    {
      angrymultiplier = 1;
    }
  }

  ArrayList<Dungeon> build()
  {
    bird.name= "The Temple of the Birds";
    bird.description = "A mystical temple dedicated to the spirits of communication, embodied as birds. It is said to be different every time one enters.";
    bird.addRoom(new Room(0, 0, 0, 20, 20), 0, 0);
    bird.addRoom(new Room(0, 1, 0, 20, 20), 1, 0);
    bird.addRoom(new Room(0, 2, 0, 20, 20), 2, 0);
    bird.addRoom(new Room(0, 2, 1, 20, 20), 2, 1);
    bird.addRoom(new Room(0, 1, 1, 20, 20), 1, 1);
    bird.addRoom(new Room(0, 0, 1, 20, 20), 0, 1);
    bird.addRoom(new Room(0, 0, 2, 20, 20), 0, 2);
    bird.addRoom(new Room(0, 1, 2, 20, 20), 1, 2);
    bird.addRoom(new Room(0, 2, 2, 10, 10), 2, 2);
    if (angrycoefficient < 60)
    {
      for (int x=0; x < angrymultiplier/2;x++)
      {
        bird.getRoom(0, 0).addEnemy(new Rat(x, x, 1, 1, bird.getRoom(0, 0).getMultiplier()));
      }
    }
    else
    {
      for (int x=0; x < angrymultiplier/2;x++)
      {
        bird.getRoom(0, 0).addEnemy(new Zombie(x, x, 1, 1, bird.getRoom(0, 0).getMultiplier()));
      }
    }

    if (angrycoefficient < 65)
    {
      for (int x=0; x < angrymultiplier;x++)
      {
        bird.getRoom(1, 0).addEnemy(new Rat(x, x, 1, 1, bird.getRoom(1, 0).getMultiplier()));
      }
    }
    else
    {
      for (int x=0; x < angrymultiplier;x++)
      {
        bird.getRoom(1, 0).addEnemy(new Zombie(x, x, 1, 1, bird.getRoom(1, 0).getMultiplier()));
      }
    }
    if (angrycoefficient < 55)
    {
      for (int x=0; x < angrymultiplier;x++)
      {
        bird.getRoom(2, 0).addEnemy(new Rat(x, x, 1, 1, bird.getRoom(2, 0).getMultiplier()));
      }
    }
    else if (angrycoefficient >70)
    {
      bird.getRoom(2, 0).addEnemy(new BlackKnight(0, 0, 1, 1, bird.getRoom(2, 0).getMultiplier()));
    }
    else
    {
      for (int x=0; x < angrymultiplier;x++)
      {
        bird.getRoom(2, 0).addEnemy(new Zombie(x, x, 1, 1, bird.getRoom(2, 0).getMultiplier()));
      }
    }


    if (angrycoefficient < 60)
    {
      for (int x=0; x < angrymultiplier/2;x++)
      {
        bird.getRoom(2, 1).addEnemy(new Zombie(x, x, 1, 1, bird.getRoom(2, 1).getMultiplier()));
      }
    }
    else
    {
      for (int x=0; x < angrymultiplier/2;x++)
      {
        bird.getRoom(2, 1).addEnemy(new BlackKnight(x, x, 1, 1, bird.getRoom(2, 1).getMultiplier()));
      }
    }

    if (angrycoefficient < 65)
    {
      for (int x=0; x < angrymultiplier;x++)
      {
        bird.getRoom(1, 1).addEnemy(new Zombie(x, x, 1, 1, bird.getRoom(1, 1).getMultiplier()));
      }
    }
    else
    {
      for (int x=0; x < angrymultiplier;x++)
      {
        bird.getRoom(1, 1).addEnemy(new BlackKnight(x, x, 1, 1, bird.getRoom(1, 1).getMultiplier()));
      }
    }

    if (angrycoefficient < 55)
    {
      for (int x=0; x < angrymultiplier;x++)
      {
        bird.getRoom(0, 1).addEnemy(new Zombie(x, x, 1, 1, bird.getRoom(0, 1).getMultiplier()));
      }
    }
    else if (angrycoefficient >70)
    {
      bird.getRoom(0, 1).addEnemy(new Dragon(0, 0, 1, 1, bird.getRoom(0, 1).getMultiplier()));
    }
    else
    {
      for (int x=0; x < angrymultiplier;x++)
      {
        bird.getRoom(0, 1).addEnemy(new BlackKnight(x, x, 1, 1, bird.getRoom(0, 1).getMultiplier()));
      }
    }

    for (int x=0; x < angrymultiplier;x++)
    {
      bird.getRoom(0, 2).addEnemy(new Zombie(x, x, 1, 1, bird.getRoom(0, 2).getMultiplier()));
    }
    for (int x=0; x < angrymultiplier/2;x++)
    {
      bird.getRoom(0, 2).addEnemy(new BlackKnight(x, x, 1, 1, bird.getRoom(0, 2).getMultiplier()));
    }
    if (angrycoefficient >70)
    {
      bird.getRoom(0, 2).addEnemy(new Dragon(0, 0, 1, 1, bird.getRoom(0, 2).getMultiplier()));
    }

    bird.getRoom(1, 2).addEnemy(new Dragon(0, 0, 1, 1, bird.getRoom(1, 2).getMultiplier()));
    if (angrycoefficient >75)
    {
      for (int x=0; x <= angrymultiplier/3; x++)
      {
        bird.getRoom(1, 2).addEnemy(new Dragon(x, x, 1, 1, bird.getRoom(1, 2).getMultiplier()));
      }
    }


    bird.getRoom(2, 2).winner=true;

    bird.getRoom(2, 2).addEnemy(new NPC(5, 5, 1, 1, bird.getRoom(2, 2).getMultiplier(), font, "Thank you, Daniel. There are other knights to be freed!", 0, 6, 10, 4 ));

    bird.getRoom(0,0).addDoor(bird.getRoom(1,0),bird.getRoom(0,0).getDUWidth()-1,bird.getRoom(0,2).getDUHeight()/2,1,1, false,2);
    
    bird.getRoom(1,0).addDoor(bird.getRoom(0,0),0,bird.getRoom(1,0).getDUHeight()/2,1,1, false,3);
    bird.getRoom(1,0).addDoor(bird.getRoom(2,0),bird.getRoom(1,0).getDUWidth()-1,bird.getRoom(1,0).getDUHeight()/2,1,1, false,2);
    
    bird.getRoom(2,0).addDoor(bird.getRoom(1,0),0,bird.getRoom(2,0).getDUHeight()/2,1,1, false,3);
    bird.getRoom(2,0).addDoor(bird.getRoom(2,1),bird.getRoom(2,0).getDUWidth()/2,0,1,1, false,0);
    
    bird.getRoom(2,1).addDoor(bird.getRoom(1,1),0,bird.getRoom(2,1).getDUHeight()/2,1,1, false,3);
    bird.getRoom(2,1).addDoor(bird.getRoom(2,0),bird.getRoom(2,1).getDUWidth()/2,bird.getRoom(2,1).getDUHeight()-1,1,1, false,1);
    
    bird.getRoom(1,1).addDoor(bird.getRoom(0,1),0,bird.getRoom(1,1).getDUHeight()/2,1,1, false,3);
    bird.getRoom(1,1).addDoor(bird.getRoom(2,1),bird.getRoom(1,1).getDUWidth()-1,bird.getRoom(1,0).getDUHeight()/2,1,1, false,2);
    
    bird.getRoom(0,1).addDoor(bird.getRoom(0,2),bird.getRoom(0,1).getDUWidth()/2,0,1,1, false,0);
    bird.getRoom(0,1).addDoor(bird.getRoom(1,1),bird.getRoom(0,1).getDUWidth()-1,bird.getRoom(0,1).getDUHeight()/2,1,1, false,2);
    
    bird.getRoom(0,2).addDoor(bird.getRoom(0,1),bird.getRoom(0,2).getDUWidth()/2,bird.getRoom(0,2).getDUHeight()-1,1,1, false,1);
    bird.getRoom(0,2).addDoor(bird.getRoom(1,2),bird.getRoom(0,2).getDUWidth()-1,bird.getRoom(0,2).getDUHeight()/2,1,1, false,2);
    
    bird.getRoom(1,2).addDoor(bird.getRoom(1,1),0,bird.getRoom(1,2).getDUHeight()/2,1,1, false,3);
    bird.getRoom(1,2).addDoor(bird.getRoom(2,2),bird.getRoom(1,2).getDUWidth()-1,bird.getRoom(1,0).getDUHeight()/2,1,1, false,2);
    
    bird.getRoom(2,2).addDoor(bird.getRoom(1,2),0,bird.getRoom(2,2).getDUHeight()/2,1,1, false,3);

    bird.startx=0;
    bird.starty=0;

    levels.add(bird);

    println(firsttweet);
    println("ANGRY COUNTER IS: " + angrycoefficient);

    return levels;
  }
}

