class Actor extends Thing
{
  boolean killable;
  boolean dead;
  int hp;
  boolean invincible;
  int invincibilityframes;
  int invincibilitycounter;
  int direction;
  boolean isenemy;
  boolean poofs;
  boolean spitting;
  Actor parent;
  
  Actor(double ix, double iy, double iw, double ih, double m)
  {
    super(ix, iy, iw, ih, m);
    killable = true;
    dead = false;
    passable = false;
    hp = 1;
    hurts = true;
    damage = 1;
    invincibilityframes = 20;
    invincibilitycounter = invincibilityframes;
    direction = 0;
    isenemy = true;
    poofs = false;
    spitting = false;
  }
  
  String getType()
  {
    return("Actor");
  }
  
  void drawSelf()
  {
    if(invincible)
    {
     fill(255,0,0); 
    }
    else
    {
    fill(81, 185, 89);
    }
    rect((int) tx, (int) ty, (int) w, (int) h);
  }
  
  void act()
  {
//    if(tx > 0)
//    {
//      changeX(-3);
//    }
//    else
//    {
//      changeX(3);
//    }
if(invincible)
{
 invincibilitycounter--;
 if(invincibilitycounter == 0)
 {
  invincibilitycounter = invincibilityframes;
  invincible = false;
 } 
}
  }
  
  void setMultiplier(double m)
  {
    double temp = (m/multiplier);
//    tx = width/2;
//    ty = height/2;
    w *= temp;
    h *= temp;
    multiplier = m;
    boundbox= new Rectangle(tx, ty, w , h );
  }
  
  void takeHit(int damage, int dir)
  {
    if(!invincible)
    {
    hp -= damage;
    if (hp <= 0)
    {
     dead = true; 
    }
    invincible=true;
    }
    else
    {
    invincible = true;
    }
    if(dir==0)
    {
     changeY(-5); 
    }
    else if(dir == 1)
    {
     changeY(5); 
    }
    else if(dir == 2)
    {
     changeX(5); 
    }
    else
    {
     changeX(-5); 
    }
  }
  
  boolean getKillable()
  {
    return killable;
  }
  
  void setKillable(boolean b)
  {
    killable = b;
  }
  
  boolean getDead()
  {
   return dead; 
  }
  
  void setDead(boolean b)
  {
    dead = b;
  }
  
  int getHP()
  {
    return hp;
  }
  
  void setHP(int i)
  {
    hp = i;
    if(hp <= 0)
    {
     setDead(true); 
    }
  }
  
  int getDirection()
  {
    return direction;
  }
  
  void setDirection(int i)
  {
    direction = i;
  }
  
  double distanceTo(Actor a)
  {
   double xdist = pow((float)(this.getX() - a.getX()), 2);
   double ydist = pow((float)(this.getY() - a.getY()), 2);
   return(sqrt((float)(xdist + ydist))); 
  }
  
  boolean getIsEnemy()
  {
    return isenemy;
  }
  
  void setIsEnemy(boolean b)
  {
   isenemy= b; 
  }
  
  boolean getPoofs()
  {
   return poofs; 
  }
  
  void setPoofs(boolean b)
  {
   poofs = b; 
  }
  
  boolean getSpitting()
  {
   return spitting; 
  }
  
  void setSpitting(boolean b)
  {
   spitting = b; 
  }
  
  void setParent(Actor a)
  {
   parent = a; 
  }
  
  Actor getParent()
  {
   return parent; 
  }
  
  void locomote(int dir)
  {
   if(dir==0)
    {
     changeY(-h); 
    }
    else if(dir == 1)
    {
     changeY(h); 
    }
    else if(dir == 2)
    {
     changeX(w); 
    }
    else
    {
     changeX(-w); 
    } 
  }
  
}
