/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
implements Iterable<Row> {
    protected int rowCount;
    protected boolean commaSeparatedValues = false;
    protected boolean awfulCSV = false;
    protected String missingString = null;
    protected int missingInt = 0;
    protected long missingLong = 0L;
    protected float missingFloat = Float.NaN;
    protected double missingDouble = Double.NaN;
    protected int missingCategory = -1;
    String[] columnTitles;
    HashMapBlows[] columnCategories;
    HashMap<String, Integer> columnIndices;
    protected Object[] columns = new Object[0];
    static final int STRING = 0;
    static final int INT = 1;
    static final int LONG = 2;
    static final int FLOAT = 3;
    static final int DOUBLE = 4;
    static final int CATEGORICAL = 5;
    int[] columnTypes = new int[0];
    protected RowIterator rowIterator;

    public Table() {
        this.columnCategories = new HashMapBlows[0];
    }

    public Table(File file) {
        this(PApplet.createReader(file));
    }

    public Table(PApplet pApplet, String string) {
        this(pApplet.createReader(string));
    }

    public Table(BufferedReader bufferedReader) {
        this.columnCategories = new HashMapBlows[0];
        try {
            boolean bl = this.peekCSV(bufferedReader);
            if (bl) {
                this.parseCSV(bufferedReader);
            } else {
                this.parseTSV(bufferedReader);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Table(ResultSet resultSet) {
        this();
        try {
            int n;
            int n2;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            this.setColumnCount(n3);
            block15: for (n2 = 0; n2 < n3; ++n2) {
                this.setColumnTitle(n2, resultSetMetaData.getColumnName(n2 + 1));
                n = resultSetMetaData.getColumnType(n2 + 1);
                switch (n) {
                    case -6: 
                    case 4: 
                    case 5: {
                        this.setColumnType(n2, 1);
                        continue block15;
                    }
                    case -5: {
                        this.setColumnType(n2, 2);
                        continue block15;
                    }
                    case 6: {
                        this.setColumnType(n2, 3);
                        continue block15;
                    }
                    case 3: 
                    case 7: 
                    case 8: {
                        this.setColumnType(n2, 4);
                    }
                }
            }
            n2 = 0;
            while (resultSet.next()) {
                block17: for (n = 0; n < n3; ++n) {
                    switch (this.columnTypes[n]) {
                        case 0: {
                            this.setString(n2, n, resultSet.getString(n + 1));
                            continue block17;
                        }
                        case 1: {
                            this.setInt(n2, n, resultSet.getInt(n + 1));
                            continue block17;
                        }
                        case 2: {
                            this.setLong(n2, n, resultSet.getLong(n + 1));
                            continue block17;
                        }
                        case 3: {
                            this.setFloat(n2, n, resultSet.getFloat(n + 1));
                            continue block17;
                        }
                        case 4: {
                            this.setDouble(n2, n, resultSet.getDouble(n + 1));
                            continue block17;
                        }
                        default: {
                            throw new IllegalArgumentException("column type " + this.columnTypes[n] + " not supported.");
                        }
                    }
                }
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    protected boolean peekCSV(BufferedReader bufferedReader) throws IOException {
        int n;
        char[] cArray = new char[100];
        int n2 = cArray.length;
        bufferedReader.mark(n2);
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2 && (n = bufferedReader.read()) != -1; ++i) {
            if (n == 44) {
                ++n3;
            }
            if (n != 9) continue;
            ++n4;
        }
        bufferedReader.reset();
        return n3 > n4;
    }

    public void parse(BufferedReader bufferedReader) throws IOException {
        if (this.commaSeparatedValues) {
            if (this.awfulCSV) {
                this.parseAwfulCSV(bufferedReader);
            } else {
                this.parseCSV(bufferedReader);
            }
        } else {
            this.parseTSV(bufferedReader);
        }
    }

    public void parseTSV(BufferedReader bufferedReader) throws IOException {
        this.parseBasic(bufferedReader, true);
    }

    public void parseCSV(BufferedReader bufferedReader) throws IOException {
        this.parseBasic(bufferedReader, false);
    }

    protected void parseBasic(BufferedReader bufferedReader, boolean bl) throws IOException {
        String string = null;
        int n = 0;
        if (this.rowCount == 0) {
            this.setRowCount(10);
        }
        int n2 = -1;
        while ((string = bufferedReader.readLine()) != null) {
            int n3;
            if (n == this.getRowCount()) {
                this.setRowCount(n << 1);
            }
            this.setRow(n, bl ? PApplet.split(string, '\t') : Table.splitLineCSV(string));
            if (++n % 10000 != 0) continue;
            if (n < this.rowCount && (n3 = 100 * n / this.rowCount) != n2) {
                System.out.println(n3 + "%");
                n2 = n3;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (n != this.getRowCount()) {
            this.setRowCount(n);
        }
    }

    public void convertTSV(BufferedReader bufferedReader, File file) throws IOException {
        this.convertBasic(bufferedReader, true, file);
    }

    protected void convertBasic(BufferedReader bufferedReader, boolean bl, File file) throws IOException {
        String string;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 16384);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(this.getColumnCount());
        if (this.columnTitles != null) {
            dataOutputStream.writeBoolean(true);
            for (String string2 : this.columnTitles) {
                dataOutputStream.writeUTF(string2);
            }
        } else {
            dataOutputStream.writeBoolean(false);
        }
        for (int n : this.columnTypes) {
            dataOutputStream.writeInt(n);
        }
        Object var7_9 = null;
        int n = -1;
        int n2 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            int n3;
            this.convertRow(dataOutputStream, bl ? PApplet.split(string, '\t') : Table.splitLineCSV(string));
            if (++n2 % 10000 != 0 || n2 >= this.rowCount || (n3 = 100 * n2 / this.rowCount) == n) continue;
            System.out.println(n3 + "%");
            n = n3;
        }
        int n4 = 0;
        for (HashMapBlows hashMapBlows : this.columnCategories) {
            if (hashMapBlows == null) {
                dataOutputStream.writeInt(0);
            } else {
                hashMapBlows.write(dataOutputStream);
                hashMapBlows.writeln(PApplet.createWriter(new File(this.columnTitles[n4] + ".categories")));
            }
            ++n4;
        }
        dataOutputStream.flush();
        dataOutputStream.close();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        randomAccessFile.writeInt(this.rowCount);
        randomAccessFile.close();
    }

    public void parseAwfulCSV(BufferedReader bufferedReader) throws IOException {
        int n;
        char[] cArray = new char[100];
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        while ((n = bufferedReader.read()) != -1) {
            if (bl) {
                if (n == 34) {
                    bufferedReader.mark(1);
                    if (bufferedReader.read() == 34) {
                        if (n2 == cArray.length) {
                            cArray = PApplet.expand(cArray);
                        }
                        cArray[n2++] = 34;
                        continue;
                    }
                    bufferedReader.reset();
                    bl = false;
                    continue;
                }
                if (n2 == cArray.length) {
                    cArray = PApplet.expand(cArray);
                }
                cArray[n2++] = (char)n;
                continue;
            }
            if (n == 34) {
                bl = true;
                continue;
            }
            if (n == 13) {
                bufferedReader.mark(1);
                if (bufferedReader.read() != 10) {
                    bufferedReader.reset();
                }
                this.setString(n3, n4, new String(cArray, 0, n2));
                n2 = 0;
                ++n3;
                n4 = 0;
                continue;
            }
            if (n == 10) {
                this.setString(n3, n4, new String(cArray, 0, n2));
                n2 = 0;
                ++n3;
                n4 = 0;
                continue;
            }
            if (n == 44) {
                this.setString(n3, n4, new String(cArray, 0, n2));
                n2 = 0;
                this.checkColumn(++n4);
                continue;
            }
            if (n2 == cArray.length) {
                cArray = PApplet.expand(cArray);
            }
            cArray[n2++] = (char)n;
        }
        if (n2 > 0) {
            this.setString(n3, n4, new String(cArray, 0, n2));
        }
    }

    protected String[] splitLine(String string) {
        return this.commaSeparatedValues ? Table.splitLineCSV(string) : PApplet.split(string, '\t');
    }

    public static String[] splitLineCSV(String string) {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = 1;
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (!bl && cArray[i] == ',') {
                ++n2;
                continue;
            }
            if (cArray[i] != '\"') continue;
            bl = !bl;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < cArray.length) {
            n = n4;
            int n5 = Table.nextComma(cArray, n4);
            n4 = n5 + 1;
            if (cArray[n] == '\"' && cArray[n5 - 1] == '\"') {
                --n5;
            }
            int n6 = ++n;
            int n7 = n;
            while (n6 < n5) {
                if (cArray[n6] == '\"') {
                    ++n6;
                }
                if (n6 != n7) {
                    cArray[n7] = cArray[n6];
                }
                ++n6;
                ++n7;
            }
            String string2 = new String(cArray, n, n7 - n);
            stringArray[n3++] = string2;
        }
        for (n = n3; n < stringArray.length; ++n) {
            stringArray[n] = "";
        }
        return stringArray;
    }

    static int nextComma(char[] cArray, int n) {
        boolean bl = false;
        for (int i = n; i < cArray.length; ++i) {
            if (!bl && cArray[i] == ',') {
                return i;
            }
            if (cArray[i] != '\"') continue;
            bl = !bl;
        }
        return cArray.length;
    }

    public void writeTSV(PrintWriter printWriter) {
        int n;
        if (this.columnTitles != null) {
            for (n = 0; n < this.columns.length; ++n) {
                if (n != 0) {
                    printWriter.print('\t');
                }
                if (this.columnTitles[n] == null) continue;
                printWriter.print(this.columnTitles[n]);
            }
            printWriter.println();
        }
        for (n = 0; n < this.rowCount; ++n) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                String string;
                if (i != 0) {
                    printWriter.print('\t');
                }
                if ((string = this.getString(n, i)) == null) continue;
                printWriter.print(string);
            }
            printWriter.println();
        }
        printWriter.flush();
    }

    public void writeCSV(PrintWriter printWriter) {
        int n;
        if (this.columnTitles != null) {
            for (n = 0; n < this.columns.length; ++n) {
                if (n != 0) {
                    printWriter.print(',');
                }
                if (this.columnTitles[n] == null) continue;
                this.writeEntryCSV(printWriter, this.columnTitles[n]);
            }
            printWriter.println();
        }
        for (n = 0; n < this.rowCount; ++n) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                String string;
                if (i != 0) {
                    printWriter.print(',');
                }
                if ((string = this.getString(n, i)) == null) continue;
                this.writeEntryCSV(printWriter, string);
            }
            printWriter.println();
        }
        printWriter.flush();
    }

    protected void writeEntryCSV(PrintWriter printWriter, String string) {
        if (string != null) {
            if (string.indexOf(34) != -1) {
                char[] cArray = string.toCharArray();
                printWriter.print('\"');
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] == '\"') {
                        printWriter.print("\"\"");
                        continue;
                    }
                    printWriter.print(cArray[i]);
                }
                printWriter.print('\"');
            } else if (string.indexOf(44) != -1 || string.indexOf(10) != -1 || string.indexOf(13) != -1) {
                printWriter.print('\"');
                printWriter.print(string);
                printWriter.print('\"');
            } else if (string.length() > 0 && (string.charAt(0) == ' ' || string.charAt(string.length() - 1) == ' ')) {
                printWriter.print('\"');
                printWriter.print(string);
                printWriter.print('\"');
            } else {
                printWriter.print(string);
            }
        }
    }

    public void writeHTML(PrintWriter printWriter) {
        printWriter.println("<table>");
        for (int i = 0; i < this.getRowCount(); ++i) {
            printWriter.println("  <tr>");
            for (int j = 0; j < this.getColumnCount(); ++j) {
                String string = this.getString(i, j);
                printWriter.print("    <td>");
                this.writeEntryHTML(printWriter, string);
                printWriter.println("</td>");
            }
            printWriter.println("  </tr>");
        }
        printWriter.println("</table>");
        printWriter.flush();
    }

    protected void writeEntryHTML(PrintWriter printWriter, String string) {
        for (char c : string.toCharArray()) {
            if (c < ' ' || c > '\u007f') {
                printWriter.print("&#");
                printWriter.print((int)c);
                printWriter.print(';');
                continue;
            }
            printWriter.print(c);
        }
    }

    public boolean writeCSV(File file) {
        try {
            this.writeCSV(new PrintWriter(new FileWriter(file)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean writeTSV(File file) {
        try {
            this.writeTSV(new PrintWriter(new FileWriter(file)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public void addColumn() {
        this.addColumn(null, 0);
    }

    public void addColumn(String string) {
        this.addColumn(string, 0);
    }

    public void addColumn(String string, int n) {
        this.insertColumn(this.columns.length, string, n);
    }

    public void insertColumn(int n) {
        this.insertColumn(n, null, 0);
    }

    public void insertColumn(int n, String string) {
        this.insertColumn(n, string, 0);
    }

    public void insertColumn(int n, String string, int n2) {
        if (string != null && this.columnTitles == null) {
            this.columnTitles = new String[this.columns.length];
        }
        if (this.columnTitles != null) {
            this.columnTitles = PApplet.splice(this.columnTitles, string, n);
        }
        this.columnTypes = PApplet.splice(this.columnTypes, n2, n);
        this.columnCategories = (HashMapBlows[])PApplet.splice(this.columnCategories, new HashMapBlows(), n);
        Object[] objectArray = new Object[this.columns.length + 1];
        System.arraycopy(this.columns, 0, objectArray, 0, n);
        System.arraycopy(this.columns, n, objectArray, n + 1, this.columns.length - n + 1);
        this.columns = objectArray;
        switch (n2) {
            case 1: {
                this.columns[n] = new int[this.rowCount];
                break;
            }
            case 2: {
                this.columns[n] = new long[this.rowCount];
                break;
            }
            case 3: {
                this.columns[n] = new float[this.rowCount];
                break;
            }
            case 4: {
                this.columns[n] = new double[this.rowCount];
                break;
            }
            case 0: {
                this.columns[n] = new String[this.rowCount];
                break;
            }
            case 5: {
                this.columns[n] = new int[this.rowCount];
            }
        }
    }

    public void removeColumn(String string) {
        this.removeColumn(this.getColumnIndex(string));
    }

    public void removeColumn(int n) {
        Object[] objectArray = new Object[this.columns.length + 1];
        System.arraycopy(this.columns, 0, objectArray, 0, n);
        System.arraycopy(this.columns, n + 1, objectArray, n, this.columns.length - n + 1);
        this.columns = objectArray;
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public void setColumnCount(int n) {
        int n2 = this.columns.length;
        if (n2 != n) {
            this.columns = (Object[])PApplet.expand(this.columns, n);
            for (int i = n2; i < n; ++i) {
                this.columns[i] = new String[this.rowCount];
            }
            if (this.columnTitles != null) {
                this.columnTitles = PApplet.expand(this.columnTitles, n);
            }
            this.columnTypes = PApplet.expand(this.columnTypes, n);
            this.columnCategories = (HashMapBlows[])PApplet.expand(this.columnCategories, n);
        }
    }

    public void setColumnType(String string, String string2) {
        this.setColumnType(this.getColumnIndex(string), string2);
    }

    public void setColumnType(int n, String string) {
        int n2 = -1;
        if (string.equals("String")) {
            n2 = 0;
        } else if (string.equals("int")) {
            n2 = 1;
        } else if (string.equals("long")) {
            n2 = 2;
        } else if (string.equals("float")) {
            n2 = 3;
        } else if (string.equals("double")) {
            n2 = 4;
        } else if (string.equals("categorical")) {
            n2 = 5;
        } else {
            throw new IllegalArgumentException("'" + string + "' is not a valid column type.");
        }
        this.setColumnType(n, n2);
    }

    protected void setColumnType(String string, int n) {
        this.setColumnType(this.getColumnIndex(string), n);
    }

    protected void setColumnType(int n, int n2) {
        switch (n2) {
            case 1: {
                int[] nArray = new int[this.rowCount];
                for (int i = 0; i < this.rowCount; ++i) {
                    String string = this.getString(i, n);
                    nArray[i] = PApplet.parseInt(string, this.missingInt);
                }
                this.columns[n] = nArray;
                break;
            }
            case 2: {
                long[] lArray = new long[this.rowCount];
                for (int i = 0; i < this.rowCount; ++i) {
                    String string = this.getString(i, n);
                    try {
                        lArray[i] = Long.parseLong(string);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        lArray[i] = this.missingLong;
                    }
                }
                this.columns[n] = lArray;
                break;
            }
            case 3: {
                float[] fArray = new float[this.rowCount];
                for (int i = 0; i < this.rowCount; ++i) {
                    String string = this.getString(i, n);
                    fArray[i] = PApplet.parseFloat(string, this.missingFloat);
                }
                this.columns[n] = fArray;
                break;
            }
            case 4: {
                double[] dArray = new double[this.rowCount];
                for (int i = 0; i < this.rowCount; ++i) {
                    String string = this.getString(i, n);
                    try {
                        dArray[i] = Double.parseDouble(string);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        dArray[i] = this.missingDouble;
                    }
                }
                this.columns[n] = dArray;
                break;
            }
            case 0: {
                if (this.columnTypes[n] == 0) break;
                String[] stringArray = new String[this.rowCount];
                for (int i = 0; i < this.rowCount; ++i) {
                    stringArray[i] = this.getString(i, n);
                }
                this.columns[n] = stringArray;
                break;
            }
            case 5: {
                int[] nArray = new int[this.rowCount];
                HashMapBlows hashMapBlows = new HashMapBlows();
                for (int i = 0; i < this.rowCount; ++i) {
                    String string = this.getString(i, n);
                    nArray[i] = hashMapBlows.index(string);
                }
                this.columnCategories[n] = hashMapBlows;
                this.columns[n] = nArray;
                break;
            }
            default: {
                throw new IllegalArgumentException("That's not a valid column type.");
            }
        }
        this.columnTypes[n] = n2;
    }

    public void setTableType(String string) {
        for (int i = 0; i < this.columns.length; ++i) {
            this.setColumnType(i, string);
        }
    }

    public void setColumnTypes(Table table) {
        this.setColumnTitles(table.getStringColumn(0));
        if (table.getColumnCount() > 1) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                this.setColumnType(i, table.getString(i, 1));
            }
        }
    }

    public String[] removeTitleRow() {
        String[] stringArray = this.getStringRow(0);
        this.removeRow(0);
        this.setColumnTitles(stringArray);
        return stringArray;
    }

    public void setColumnTitles(String[] stringArray) {
        if (stringArray != null) {
            this.checkColumn(stringArray.length - 1);
        }
        this.columnTitles = stringArray;
        this.columnIndices = null;
    }

    public void setColumnTitle(int n, String string) {
        this.checkColumn(n);
        if (this.columnTitles == null) {
            this.columnTitles = new String[this.getColumnCount()];
        }
        this.columnTitles[n] = string;
        this.columnIndices = null;
    }

    public String[] getColumnTitles() {
        return this.columnTitles;
    }

    public String getColumnTitle(int n) {
        return this.columnTitles == null ? null : this.columnTitles[n];
    }

    public int getColumnIndex(String string) {
        return this.getColumnIndex(string, true);
    }

    protected int getColumnIndex(String string, boolean bl) {
        Integer n;
        if (this.columnTitles == null) {
            System.err.println("Can't get column indices because no column titles are set.");
            return -1;
        }
        if (this.columnIndices == null) {
            this.columnIndices = new HashMap();
            for (int i = 0; i < this.columns.length; ++i) {
                this.columnIndices.put(this.columnTitles[i], i);
            }
        }
        if ((n = this.columnIndices.get(string)) == null) {
            if (bl) {
                System.err.println("No column named '" + string + "' was found.");
            }
            return -1;
        }
        return n;
    }

    public int checkColumnIndex(String string) {
        int n = this.getColumnIndex(string, false);
        if (n != -1) {
            return n;
        }
        this.addColumn(string);
        return this.getColumnCount() - 1;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int n) {
        if (n != this.rowCount) {
            int n2;
            if (n > 1000000) {
                System.out.println("setting row count to " + PApplet.nfc(n));
            }
            long l = System.currentTimeMillis();
            for (n2 = 0; n2 < this.columns.length; ++n2) {
                switch (this.columnTypes[n2]) {
                    case 1: {
                        this.columns[n2] = PApplet.expand((int[])this.columns[n2], n);
                        break;
                    }
                    case 2: {
                        this.columns[n2] = PApplet.expand((long[])this.columns[n2], n);
                        break;
                    }
                    case 3: {
                        this.columns[n2] = PApplet.expand((float[])this.columns[n2], n);
                        break;
                    }
                    case 4: {
                        this.columns[n2] = PApplet.expand((double[])this.columns[n2], n);
                        break;
                    }
                    case 0: {
                        this.columns[n2] = PApplet.expand((String[])this.columns[n2], n);
                        break;
                    }
                    case 5: {
                        this.columns[n2] = PApplet.expand((int[])this.columns[n2], n);
                    }
                }
                if (n <= 1000000) continue;
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (n > 1000000) {
                n2 = (int)(System.currentTimeMillis() - l);
                System.out.println("  resize took " + PApplet.nfc(n2) + " ms");
            }
        }
        this.rowCount = n;
    }

    public void addRow() {
        this.setRowCount(this.rowCount + 1);
    }

    public void addRow(String[] stringArray) {
        this.setRow(this.getRowCount(), stringArray);
    }

    public void insertRow(int n, String[] stringArray) {
        block7: for (int i = 0; i < this.columns.length; ++i) {
            switch (this.columnTypes[i]) {
                case 1: 
                case 5: {
                    Object[] objectArray = new int[this.rowCount + 1];
                    System.arraycopy(this.columns[i], 0, objectArray, 0, n);
                    System.arraycopy(this.columns[i], n, objectArray, n + 1, this.rowCount - n + 1);
                    this.columns[i] = objectArray;
                    continue block7;
                }
                case 2: {
                    Object[] objectArray = new long[this.rowCount + 1];
                    System.arraycopy(this.columns[i], 0, objectArray, 0, n);
                    System.arraycopy(this.columns[i], n, objectArray, n + 1, this.rowCount - n + 1);
                    this.columns[i] = objectArray;
                    continue block7;
                }
                case 3: {
                    Object[] objectArray = new float[this.rowCount + 1];
                    System.arraycopy(this.columns[i], 0, objectArray, 0, n);
                    System.arraycopy(this.columns[i], n, objectArray, n + 1, this.rowCount - n + 1);
                    this.columns[i] = objectArray;
                    continue block7;
                }
                case 4: {
                    Object[] objectArray = new double[this.rowCount + 1];
                    System.arraycopy(this.columns[i], 0, objectArray, 0, n);
                    System.arraycopy(this.columns[i], n, objectArray, n + 1, this.rowCount - n + 1);
                    this.columns[i] = objectArray;
                    continue block7;
                }
                case 0: {
                    Object[] objectArray = new String[this.rowCount + 1];
                    System.arraycopy(this.columns[i], 0, objectArray, 0, n);
                    System.arraycopy(this.columns[i], n, objectArray, n + 1, this.rowCount - n + 1);
                    this.columns[i] = objectArray;
                    continue block7;
                }
            }
        }
        this.setRow(n, stringArray);
        ++this.rowCount;
    }

    public void removeRow(int n) {
        block7: for (int i = 0; i < this.columns.length; ++i) {
            switch (this.columnTypes[i]) {
                case 1: 
                case 5: {
                    Object[] objectArray = new int[this.rowCount - 1];
                    System.arraycopy(this.columns[i], 0, objectArray, 0, n);
                    System.arraycopy(this.columns[i], n + 1, objectArray, n, this.rowCount - n - 1);
                    this.columns[i] = objectArray;
                    continue block7;
                }
                case 2: {
                    Object[] objectArray = new long[this.rowCount - 1];
                    System.arraycopy(this.columns[i], 0, objectArray, 0, n);
                    System.arraycopy(this.columns[i], n + 1, objectArray, n, this.rowCount - n - 1);
                    this.columns[i] = objectArray;
                    continue block7;
                }
                case 3: {
                    Object[] objectArray = new float[this.rowCount - 1];
                    System.arraycopy(this.columns[i], 0, objectArray, 0, n);
                    System.arraycopy(this.columns[i], n + 1, objectArray, n, this.rowCount - n - 1);
                    this.columns[i] = objectArray;
                    continue block7;
                }
                case 4: {
                    Object[] objectArray = new double[this.rowCount - 1];
                    System.arraycopy(this.columns[i], 0, objectArray, 0, n);
                    System.arraycopy(this.columns[i], n + 1, objectArray, n, this.rowCount - n - 1);
                    this.columns[i] = objectArray;
                    continue block7;
                }
                case 0: {
                    Object[] objectArray = new String[this.rowCount - 1];
                    System.arraycopy(this.columns[i], 0, objectArray, 0, n);
                    System.arraycopy(this.columns[i], n + 1, objectArray, n, this.rowCount - n - 1);
                    this.columns[i] = objectArray;
                }
            }
        }
        --this.rowCount;
    }

    public void setRow(int n, String[] stringArray) {
        this.checkSize(n, stringArray.length - 1);
        for (int i = 0; i < stringArray.length; ++i) {
            this.setRowCol(n, i, stringArray[i]);
        }
    }

    protected void setRowCol(int n, int n2, String string) {
        switch (this.columnTypes[n2]) {
            case 0: {
                String[] stringArray = (String[])this.columns[n2];
                stringArray[n] = string;
                break;
            }
            case 1: {
                int[] nArray = (int[])this.columns[n2];
                nArray[n] = PApplet.parseInt(string, this.missingInt);
                break;
            }
            case 2: {
                long[] lArray = (long[])this.columns[n2];
                try {
                    lArray[n] = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    lArray[n] = this.missingLong;
                }
                break;
            }
            case 3: {
                float[] fArray = (float[])this.columns[n2];
                fArray[n] = PApplet.parseFloat(string, this.missingFloat);
                break;
            }
            case 4: {
                double[] dArray = (double[])this.columns[n2];
                try {
                    dArray[n] = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    dArray[n] = this.missingDouble;
                }
                break;
            }
            case 5: {
                int[] nArray = (int[])this.columns[n2];
                nArray[n] = this.columnCategories[n2].index(string);
                break;
            }
            default: {
                throw new IllegalArgumentException("That's not a valid column type.");
            }
        }
    }

    public void convertRow(DataOutputStream dataOutputStream, String[] stringArray) throws IOException {
        int n;
        if (stringArray.length > this.getColumnCount()) {
            throw new IllegalArgumentException("Row with too many columns: " + PApplet.join(stringArray, ","));
        }
        block20: for (n = 0; n < stringArray.length; ++n) {
            switch (this.columnTypes[n]) {
                case 0: {
                    dataOutputStream.writeUTF(stringArray[n]);
                    continue block20;
                }
                case 1: {
                    dataOutputStream.writeInt(PApplet.parseInt(stringArray[n], this.missingInt));
                    continue block20;
                }
                case 2: {
                    try {
                        dataOutputStream.writeLong(Long.parseLong(stringArray[n]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        dataOutputStream.writeLong(this.missingLong);
                    }
                    continue block20;
                }
                case 3: {
                    dataOutputStream.writeFloat(PApplet.parseFloat(stringArray[n], this.missingFloat));
                    continue block20;
                }
                case 4: {
                    try {
                        dataOutputStream.writeDouble(Double.parseDouble(stringArray[n]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        dataOutputStream.writeDouble(this.missingDouble);
                    }
                    continue block20;
                }
                case 5: {
                    dataOutputStream.writeInt(this.columnCategories[n].index(stringArray[n]));
                }
            }
        }
        block21: for (n = stringArray.length; n < this.getColumnCount(); ++n) {
            switch (this.columnTypes[n]) {
                case 0: {
                    dataOutputStream.writeUTF("");
                    continue block21;
                }
                case 1: {
                    dataOutputStream.writeInt(this.missingInt);
                    continue block21;
                }
                case 2: {
                    dataOutputStream.writeLong(this.missingLong);
                    continue block21;
                }
                case 3: {
                    dataOutputStream.writeFloat(this.missingFloat);
                    continue block21;
                }
                case 4: {
                    dataOutputStream.writeDouble(this.missingDouble);
                    continue block21;
                }
                case 5: {
                    dataOutputStream.writeInt(this.missingCategory);
                }
            }
        }
    }

    protected void convertRowCol(DataOutputStream dataOutputStream, int n, int n2, String string) {
        switch (this.columnTypes[n2]) {
            case 0: {
                String[] stringArray = (String[])this.columns[n2];
                stringArray[n] = string;
                break;
            }
            case 1: {
                int[] nArray = (int[])this.columns[n2];
                nArray[n] = PApplet.parseInt(string, this.missingInt);
                break;
            }
            case 2: {
                long[] lArray = (long[])this.columns[n2];
                try {
                    lArray[n] = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    lArray[n] = this.missingLong;
                }
                break;
            }
            case 3: {
                float[] fArray = (float[])this.columns[n2];
                fArray[n] = PApplet.parseFloat(string, this.missingFloat);
                break;
            }
            case 4: {
                double[] dArray = (double[])this.columns[n2];
                try {
                    dArray[n] = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    dArray[n] = this.missingDouble;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("That's not a valid column type.");
            }
        }
    }

    @Override
    public Iterator<Row> iterator() {
        if (this.rowIterator == null) {
            this.rowIterator = new RowIterator();
        }
        this.rowIterator.reset();
        return this.rowIterator;
    }

    public Iterator<Row> createIterator() {
        return new RowIterator();
    }

    public static Iterator<Row> createIterator(final ResultSet resultSet) {
        return new Iterator<Row>(){
            boolean already;

            @Override
            public boolean hasNext() {
                this.already = true;
                try {
                    return resultSet.next();
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            }

            @Override
            public Row next() {
                if (!this.already) {
                    try {
                        resultSet.next();
                    }
                    catch (SQLException sQLException) {
                        throw new RuntimeException(sQLException);
                    }
                } else {
                    this.already = false;
                }
                return new Row(){

                    public double getDouble(int n) {
                        try {
                            return resultSet.getDouble(n);
                        }
                        catch (SQLException sQLException) {
                            throw new RuntimeException(sQLException);
                        }
                    }

                    public double getDouble(String string) {
                        try {
                            return resultSet.getDouble(string);
                        }
                        catch (SQLException sQLException) {
                            throw new RuntimeException(sQLException);
                        }
                    }

                    public float getFloat(int n) {
                        try {
                            return resultSet.getFloat(n);
                        }
                        catch (SQLException sQLException) {
                            throw new RuntimeException(sQLException);
                        }
                    }

                    public float getFloat(String string) {
                        try {
                            return resultSet.getFloat(string);
                        }
                        catch (SQLException sQLException) {
                            throw new RuntimeException(sQLException);
                        }
                    }

                    public int getInt(int n) {
                        try {
                            return resultSet.getInt(n);
                        }
                        catch (SQLException sQLException) {
                            throw new RuntimeException(sQLException);
                        }
                    }

                    public int getInt(String string) {
                        try {
                            return resultSet.getInt(string);
                        }
                        catch (SQLException sQLException) {
                            throw new RuntimeException(sQLException);
                        }
                    }

                    public long getLong(int n) {
                        try {
                            return resultSet.getLong(n);
                        }
                        catch (SQLException sQLException) {
                            throw new RuntimeException(sQLException);
                        }
                    }

                    public long getLong(String string) {
                        try {
                            return resultSet.getLong(string);
                        }
                        catch (SQLException sQLException) {
                            throw new RuntimeException(sQLException);
                        }
                    }

                    public String getString(int n) {
                        try {
                            return resultSet.getString(n);
                        }
                        catch (SQLException sQLException) {
                            throw new RuntimeException(sQLException);
                        }
                    }

                    public String getString(String string) {
                        try {
                            return resultSet.getString(string);
                        }
                        catch (SQLException sQLException) {
                            throw new RuntimeException(sQLException);
                        }
                    }
                };
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException("remove() not supported");
            }
        };
    }

    public int getInt(int n, int n2) {
        this.checkBounds(n, n2);
        if (this.columnTypes[n2] == 1) {
            int[] nArray = (int[])this.columns[n2];
            return nArray[n];
        }
        String string = this.getString(n, n2);
        return string == null || string.equals(this.missingString) ? this.missingInt : PApplet.parseInt(string, this.missingInt);
    }

    public int getInt(int n, String string) {
        return this.getInt(n, this.getColumnIndex(string));
    }

    public void setMissingInt(int n) {
        this.missingInt = n;
    }

    public void setInt(int n, int n2, int n3) {
        if (this.columnTypes[n2] == 0) {
            this.setString(n, n2, String.valueOf(n3));
        } else {
            this.checkSize(n, n2);
            if (this.columnTypes[n2] != 1) {
                throw new IllegalArgumentException("Column " + n2 + " is not an int column.");
            }
            int[] nArray = (int[])this.columns[n2];
            nArray[n] = n3;
        }
    }

    public int[] getIntColumn(String string) {
        int n = this.getColumnIndex(string);
        return n == -1 ? null : this.getIntColumn(n);
    }

    public int[] getIntColumn(int n) {
        int[] nArray = new int[this.rowCount];
        for (int i = 0; i < this.rowCount; ++i) {
            nArray[i] = this.getInt(i, n);
        }
        return nArray;
    }

    public int[] getIntRow(int n) {
        int[] nArray = new int[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            nArray[i] = this.getInt(n, i);
        }
        return nArray;
    }

    public long getLong(int n, int n2) {
        this.checkBounds(n, n2);
        if (this.columnTypes[n2] == 2) {
            long[] lArray = (long[])this.columns[n2];
            return lArray[n];
        }
        String string = this.getString(n, n2);
        if (string == null || string.equals(this.missingString)) {
            return this.missingLong;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return this.missingLong;
        }
    }

    public long getLong(int n, String string) {
        return this.getLong(n, this.getColumnIndex(string));
    }

    public void setMissingLong(long l) {
        this.missingLong = l;
    }

    public void setLong(int n, int n2, long l) {
        if (this.columnTypes[n2] == 0) {
            this.setString(n, n2, String.valueOf(l));
        } else {
            this.checkSize(n, n2);
            if (this.columnTypes[n2] != 2) {
                throw new IllegalArgumentException("Column " + n2 + " is not a 'long' column.");
            }
            long[] lArray = (long[])this.columns[n2];
            lArray[n] = l;
        }
    }

    public long[] getLongColumn(String string) {
        int n = this.getColumnIndex(string);
        return n == -1 ? null : this.getLongColumn(n);
    }

    public long[] getLongColumn(int n) {
        long[] lArray = new long[this.rowCount];
        for (int i = 0; i < this.rowCount; ++i) {
            lArray[i] = this.getLong(i, n);
        }
        return lArray;
    }

    public long[] getLongRow(int n) {
        long[] lArray = new long[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            lArray[i] = this.getLong(n, i);
        }
        return lArray;
    }

    public float getFloat(int n, int n2) {
        this.checkBounds(n, n2);
        if (this.columnTypes[n2] == 3) {
            float[] fArray = (float[])this.columns[n2];
            return fArray[n];
        }
        String string = this.getString(n, n2);
        if (string == null || string.equals(this.missingString)) {
            return this.missingFloat;
        }
        return PApplet.parseFloat(string, this.missingFloat);
    }

    public float getFloat(int n, String string) {
        return this.getFloat(n, this.getColumnIndex(string));
    }

    public void setMissingFloat(float f) {
        this.missingFloat = f;
    }

    public void setFloat(int n, int n2, float f) {
        if (this.columnTypes[n2] == 0) {
            this.setString(n, n2, String.valueOf(f));
        } else {
            this.checkSize(n, n2);
            if (this.columnTypes[n2] != 3) {
                throw new IllegalArgumentException("Column " + n2 + " is not a float column.");
            }
            float[] fArray = (float[])this.columns[n2];
            fArray[n] = f;
        }
    }

    public float[] getFloatColumn(String string) {
        int n = this.getColumnIndex(string);
        return n == -1 ? null : this.getFloatColumn(n);
    }

    public float[] getFloatColumn(int n) {
        float[] fArray = new float[this.rowCount];
        for (int i = 0; i < this.rowCount; ++i) {
            fArray[i] = this.getFloat(i, n);
        }
        return fArray;
    }

    public float[] getFloatRow(int n) {
        float[] fArray = new float[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            fArray[i] = this.getFloat(n, i);
        }
        return fArray;
    }

    public double getDouble(int n, int n2) {
        this.checkBounds(n, n2);
        if (this.columnTypes[n2] == 4) {
            double[] dArray = (double[])this.columns[n2];
            return dArray[n];
        }
        String string = this.getString(n, n2);
        if (string == null || string.equals(this.missingString)) {
            return this.missingDouble;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return this.missingDouble;
        }
    }

    public double getDouble(int n, String string) {
        return this.getDouble(n, this.getColumnIndex(string));
    }

    public void setMissingDouble(double d) {
        this.missingDouble = d;
    }

    public void setDouble(int n, int n2, double d) {
        if (this.columnTypes[n2] == 0) {
            this.setString(n, n2, String.valueOf(d));
        } else {
            this.checkSize(n, n2);
            if (this.columnTypes[n2] != 4) {
                throw new IllegalArgumentException("Column " + n2 + " is not a 'double' column.");
            }
            double[] dArray = (double[])this.columns[n2];
            dArray[n] = d;
        }
    }

    public double[] getDoubleColumn(String string) {
        int n = this.getColumnIndex(string);
        return n == -1 ? null : this.getDoubleColumn(n);
    }

    public double[] getDoubleColumn(int n) {
        double[] dArray = new double[this.rowCount];
        for (int i = 0; i < this.rowCount; ++i) {
            dArray[i] = this.getDouble(i, n);
        }
        return dArray;
    }

    public double[] getDoubleRow(int n) {
        double[] dArray = new double[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            dArray[i] = this.getDouble(n, i);
        }
        return dArray;
    }

    public String getString(int n, int n2) {
        this.checkBounds(n, n2);
        if (this.columnTypes[n2] == 0) {
            String[] stringArray = (String[])this.columns[n2];
            return stringArray[n];
        }
        if (this.columnTypes[n2] == 5) {
            int n3 = this.getInt(n, n2);
            return this.columnCategories[n2].key(n3);
        }
        return String.valueOf(Array.get(this.columns[n2], n));
    }

    public String getString(int n, String string) {
        return this.getString(n, this.getColumnIndex(string));
    }

    public void setMissingString(String string) {
        this.missingString = string;
    }

    public void setString(int n, int n2, String string) {
        this.checkSize(n, n2);
        if (this.columnTypes[n2] != 0) {
            throw new IllegalArgumentException("Column " + n2 + " is not a String column.");
        }
        String[] stringArray = (String[])this.columns[n2];
        stringArray[n] = string;
    }

    public void setString(int n, String string, String string2) {
        int n2 = this.getColumnIndex(string);
        this.setString(n, n2, string2);
    }

    public String[] getStringColumn(String string) {
        int n = this.getColumnIndex(string);
        return n == -1 ? null : this.getStringColumn(n);
    }

    public String[] getStringColumn(int n) {
        String[] stringArray = new String[this.rowCount];
        for (int i = 0; i < this.rowCount; ++i) {
            stringArray[i] = this.getString(i, n);
        }
        return stringArray;
    }

    public String[] getStringRow(int n) {
        String[] stringArray = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            stringArray[i] = this.getString(n, i);
        }
        return stringArray;
    }

    public void makeNullEmpty() {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columnTypes[i] != 0) continue;
            String[] stringArray = (String[])this.columns[i];
            for (int j = 0; j < this.rowCount; ++j) {
                if (stringArray[j] != null) continue;
                stringArray[j] = "";
            }
        }
    }

    public void makeEmptyNull() {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columnTypes[i] != 0) continue;
            String[] stringArray = (String[])this.columns[i];
            for (int j = 0; j < this.rowCount; ++j) {
                if (stringArray[j] == null || stringArray[j].length() != 0) continue;
                stringArray[j] = null;
            }
        }
    }

    public float getMaxFloat() {
        boolean bl = false;
        float f = -3.4028235E38f;
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                float f2 = this.getFloat(i, j);
                if (Float.isNaN(f2)) continue;
                if (!bl) {
                    f = f2;
                    bl = true;
                    continue;
                }
                if (!(f2 > f)) continue;
                f = f2;
            }
        }
        return bl ? f : this.missingFloat;
    }

    public void removeTokens(String string) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.removeTokens(string, i);
        }
    }

    public void removeTokens(String string, int n) {
        for (int i = 0; i < this.rowCount; ++i) {
            String string2 = this.getString(i, n);
            if (string2 == null) continue;
            char[] cArray = string2.toCharArray();
            int n2 = 0;
            for (int j = 0; j < cArray.length; ++j) {
                if (string.indexOf(cArray[j]) != -1) continue;
                if (n2 != j) {
                    cArray[n2] = cArray[j];
                }
                ++n2;
            }
            if (n2 == cArray.length) continue;
            this.setString(i, n, new String(cArray, 0, n2));
        }
    }

    public void removeTokens(String string, String string2) {
        this.removeTokens(string, this.getColumnIndex(string2));
    }

    public int findRow(String string, int n) {
        this.checkBounds(-1, n);
        if (this.columnTypes[n] == 0) {
            String[] stringArray = (String[])this.columns[n];
            if (string == null) {
                for (int i = 0; i < this.rowCount; ++i) {
                    if (stringArray[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this.rowCount; ++i) {
                    if (stringArray[i] == null || !stringArray[i].equals(string)) continue;
                    return i;
                }
            }
        } else {
            for (int i = 0; i < this.rowCount; ++i) {
                String string2 = this.getString(i, n);
                if (!(string2 == null ? string == null : string2.equals(string))) continue;
                return i;
            }
        }
        return -1;
    }

    public int findRow(String string, String string2) {
        return this.findRow(string, this.getColumnIndex(string2));
    }

    public int[] findRows(String string, int n) {
        int[] nArray = new int[this.rowCount];
        int n2 = 0;
        this.checkBounds(-1, n);
        if (this.columnTypes[n] == 0) {
            String[] stringArray = (String[])this.columns[n];
            if (string == null) {
                for (int i = 0; i < this.rowCount; ++i) {
                    if (stringArray[i] != null) continue;
                    nArray[n2++] = i;
                }
            } else {
                for (int i = 0; i < this.rowCount; ++i) {
                    if (stringArray[i] == null || !stringArray[i].equals(string)) continue;
                    nArray[n2++] = i;
                }
            }
        } else {
            for (int i = 0; i < this.rowCount; ++i) {
                String string2 = this.getString(i, n);
                if (string2 == null) {
                    if (string != null) continue;
                    nArray[n2++] = i;
                    continue;
                }
                if (!string2.equals(string)) continue;
                nArray[n2++] = i;
            }
        }
        return PApplet.subset(nArray, 0, n2);
    }

    public int[] findRows(String string, String string2) {
        return this.findRows(string, this.getColumnIndex(string2));
    }

    public int matchRow(String string, int n) {
        this.checkBounds(-1, n);
        if (this.columnTypes[n] == 0) {
            String[] stringArray = (String[])this.columns[n];
            for (int i = 0; i < this.rowCount; ++i) {
                if (stringArray[i] == null || PApplet.match(stringArray[i], string) == null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.rowCount; ++i) {
                String string2 = this.getString(i, n);
                if (string2 == null || PApplet.match(string2, string) == null) continue;
                return i;
            }
        }
        return -1;
    }

    public int matchRow(String string, String string2) {
        return this.matchRow(string, this.getColumnIndex(string2));
    }

    public int[] matchRows(String string, int n) {
        int[] nArray = new int[this.rowCount];
        int n2 = 0;
        this.checkBounds(-1, n);
        if (this.columnTypes[n] == 0) {
            String[] stringArray = (String[])this.columns[n];
            for (int i = 0; i < this.rowCount; ++i) {
                if (stringArray[i] == null || PApplet.match(stringArray[i], string) == null) continue;
                nArray[n2++] = i;
            }
        } else {
            for (int i = 0; i < this.rowCount; ++i) {
                String string2 = this.getString(i, n);
                if (string2 == null || PApplet.match(string2, string) == null) continue;
                nArray[n2++] = i;
            }
        }
        return PApplet.subset(nArray, 0, n2);
    }

    public int[] matchRows(String string, String string2) {
        return this.matchRows(string, this.getColumnIndex(string2));
    }

    public void replaceAll(String string, String string2, int n) {
        this.checkBounds(-1, n);
        if (this.columnTypes[n] == 0) {
            String[] stringArray = (String[])this.columns[n];
            for (int i = 0; i < this.rowCount; ++i) {
                if (stringArray[i] == null) continue;
                stringArray[i] = stringArray[i].replaceAll(string, string2);
            }
        } else {
            throw new IllegalArgumentException("replaceAll() can only be used on String columns");
        }
    }

    public void replaceAll(String string, String string2, String string3) {
        this.replaceAll(string, string2, this.getColumnIndex(string3));
    }

    protected void checkColumn(int n) {
        if (n >= this.columns.length) {
            this.setColumnCount(n + 1);
        }
    }

    protected void checkRow(int n) {
        if (n >= this.rowCount) {
            this.setRowCount(n + 1);
        }
    }

    protected void checkSize(int n, int n2) {
        this.checkRow(n);
        this.checkColumn(n2);
    }

    protected void checkBounds(int n, int n2) {
        if (n < 0 || n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException("Row " + n + " does not exist.");
        }
        if (n2 < 0 || n2 >= this.columns.length) {
            throw new ArrayIndexOutOfBoundsException("Column " + n2 + " does not exist.");
        }
    }

    public Table createSubset(int[] nArray) {
        Table table = new Table();
        table.setColumnTitles(this.columnTitles);
        table.columnTypes = this.columnTypes;
        table.setRowCount(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            block8: for (int j = 0; j < this.columns.length; ++j) {
                switch (this.columnTypes[j]) {
                    case 0: {
                        table.setString(i, j, this.getString(n, j));
                        continue block8;
                    }
                    case 1: {
                        table.setInt(i, j, this.getInt(n, j));
                        continue block8;
                    }
                    case 2: {
                        table.setLong(i, j, this.getLong(n, j));
                        continue block8;
                    }
                    case 3: {
                        table.setFloat(i, j, this.getFloat(n, j));
                        continue block8;
                    }
                    case 4: {
                        table.setDouble(i, j, this.getDouble(n, j));
                    }
                }
            }
        }
        return table;
    }

    public String[] getUniqueEntries(String string) {
        return this.getUniqueEntries(this.getColumnIndex(string));
    }

    public String[] getUniqueEntries(int n) {
        HashMapSucks hashMapSucks = new HashMapSucks();
        for (int i = 0; i < this.getRowCount(); ++i) {
            hashMapSucks.check(this.getString(i, n));
        }
        String[] stringArray = new String[hashMapSucks.size()];
        hashMapSucks.keySet().toArray(stringArray);
        return stringArray;
    }

    public HashMap<String, Integer> getStringCount(String string) {
        return this.getStringCount(this.getColumnIndex(string));
    }

    public HashMap<String, Integer> getStringCount(int n) {
        HashMapSucks hashMapSucks = new HashMapSucks();
        for (int i = 0; i < this.rowCount; ++i) {
            String string = this.getString(i, n);
            if (string == null) continue;
            hashMapSucks.increment(string);
        }
        return hashMapSucks;
    }

    public HashMap<String, Integer> getRowLookup(int n) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            hashMap.put(this.getString(i, n), i);
        }
        return hashMap;
    }

    public void trim() {
        for (int i = 0; i < this.columns.length; ++i) {
            String[] stringArray = (String[])this.columns[i];
            for (int j = 0; j < this.rowCount; ++j) {
                if (stringArray[j] == null) continue;
                stringArray[j] = PApplet.trim(stringArray[j]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HashMapSucks
    extends HashMap<String, Integer> {
        HashMapSucks() {
        }

        void increment(String string) {
            Integer n = (Integer)this.get(string);
            if (n == null) {
                this.put(string, 1);
            } else {
                this.put(string, n + 1);
            }
        }

        void check(String string) {
            if (this.get(string) == null) {
                this.put(string, 0);
            }
        }
    }

    class HashMapBlows {
        HashMap<String, Integer> dataToIndex = new HashMap();
        ArrayList<String> indexToData = new ArrayList();

        HashMapBlows() {
        }

        int index(String string) {
            Integer n = this.dataToIndex.get(string);
            if (n != null) {
                return n;
            }
            int n2 = this.dataToIndex.size();
            this.dataToIndex.put(string, n2);
            this.indexToData.add(string);
            return n2;
        }

        String key(int n) {
            return this.indexToData.get(n);
        }

        int size() {
            return this.dataToIndex.size();
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(this.size());
            for (String string : this.indexToData) {
                dataOutputStream.writeUTF(string);
            }
        }

        void writeln(PrintWriter printWriter) throws IOException {
            for (String string : this.indexToData) {
                printWriter.println(string);
            }
            printWriter.flush();
            printWriter.close();
        }

        void read(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            this.dataToIndex = new HashMap(n);
            for (int i = 0; i < n; ++i) {
                String string = dataInputStream.readUTF();
                this.dataToIndex.put(string, i);
                this.indexToData.add(string);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RowIterator
    implements Iterator<Row> {
        int row;
        Row tableRow = new Row(){

            public String getString(int n) {
                return Table.this.getString(RowIterator.this.row, n);
            }

            public String getString(String string) {
                return Table.this.getString(RowIterator.this.row, string);
            }

            public int getInt(int n) {
                return Table.this.getInt(RowIterator.this.row, n);
            }

            public int getInt(String string) {
                return Table.this.getInt(RowIterator.this.row, string);
            }

            public long getLong(int n) {
                return Table.this.getLong(RowIterator.this.row, n);
            }

            public long getLong(String string) {
                return Table.this.getLong(RowIterator.this.row, string);
            }

            public float getFloat(int n) {
                return Table.this.getFloat(RowIterator.this.row, n);
            }

            public float getFloat(String string) {
                return Table.this.getFloat(RowIterator.this.row, string);
            }

            public double getDouble(int n) {
                return Table.this.getDouble(RowIterator.this.row, n);
            }

            public double getDouble(String string) {
                return Table.this.getDouble(RowIterator.this.row, string);
            }
        };

        RowIterator() {
        }

        @Override
        public void remove() {
            Table.this.removeRow(this.row);
        }

        @Override
        public Row next() {
            ++this.row;
            return this.tableRow;
        }

        @Override
        public boolean hasNext() {
            return this.row + 1 < Table.this.getRowCount();
        }

        public void reset() {
            this.row = -1;
        }
    }

    public static interface Row {
        public String getString(int var1);

        public String getString(String var1);

        public int getInt(int var1);

        public int getInt(String var1);

        public long getLong(int var1);

        public long getLong(String var1);

        public float getFloat(int var1);

        public float getFloat(String var1);

        public double getDouble(int var1);

        public double getDouble(String var1);
    }
}

