/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Color;
import java.awt.Image;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PStyle;

public class PGraphics
extends PImage
implements PConstants {
    protected int width1;
    protected int height1;
    public int pixelCount;
    public boolean smooth = false;
    protected boolean settingsInited;
    protected PGraphics raw;
    protected String path;
    protected boolean primarySurface;
    protected boolean[] hints = new boolean[10];
    public int colorMode;
    public float colorModeX;
    public float colorModeY;
    public float colorModeZ;
    public float colorModeA;
    boolean colorModeScale;
    boolean colorModeDefault;
    public boolean tint;
    public int tintColor;
    protected boolean tintAlpha;
    protected float tintR;
    protected float tintG;
    protected float tintB;
    protected float tintA;
    protected int tintRi;
    protected int tintGi;
    protected int tintBi;
    protected int tintAi;
    public boolean fill;
    public int fillColor = -1;
    protected boolean fillAlpha;
    protected float fillR;
    protected float fillG;
    protected float fillB;
    protected float fillA;
    protected int fillRi;
    protected int fillGi;
    protected int fillBi;
    protected int fillAi;
    public boolean stroke;
    public int strokeColor = -16777216;
    protected boolean strokeAlpha;
    protected float strokeR;
    protected float strokeG;
    protected float strokeB;
    protected float strokeA;
    protected int strokeRi;
    protected int strokeGi;
    protected int strokeBi;
    protected int strokeAi;
    protected static final float DEFAULT_STROKE_WEIGHT = 1.0f;
    protected static final int DEFAULT_STROKE_JOIN = 8;
    protected static final int DEFAULT_STROKE_CAP = 2;
    public float strokeWeight = 1.0f;
    public int strokeJoin = 8;
    public int strokeCap = 2;
    public int rectMode;
    public int ellipseMode;
    public int shapeMode;
    public int imageMode = 0;
    public PFont textFont;
    public int textAlign = 37;
    public int textAlignY = 0;
    public int textMode = 4;
    public float textSize;
    public float textLeading;
    public float ambientR;
    public float ambientG;
    public float ambientB;
    public float specularR;
    public float specularG;
    public float specularB;
    public float emissiveR;
    public float emissiveG;
    public float emissiveB;
    public float shininess;
    static final int STYLE_STACK_DEPTH = 64;
    PStyle[] styleStack = new PStyle[64];
    int styleStackDepth;
    public int backgroundColor = -3355444;
    protected boolean backgroundAlpha;
    protected float backgroundR;
    protected float backgroundG;
    protected float backgroundB;
    protected float backgroundA;
    protected int backgroundRi;
    protected int backgroundGi;
    protected int backgroundBi;
    protected int backgroundAi;
    static final int MATRIX_STACK_DEPTH = 32;
    public Image image;
    protected float calcR;
    protected float calcG;
    protected float calcB;
    protected float calcA;
    protected int calcRi;
    protected int calcGi;
    protected int calcBi;
    protected int calcAi;
    protected int calcColor;
    protected boolean calcAlpha;
    int cacheHsbKey;
    float[] cacheHsbValue = new float[3];
    protected int shape;
    public static final int DEFAULT_VERTICES = 512;
    protected float[][] vertices = new float[512][37];
    protected int vertexCount;
    protected boolean bezierInited = false;
    public int bezierDetail = 20;
    protected PMatrix3D bezierBasisMatrix = new PMatrix3D(-1.0f, 3.0f, -3.0f, 1.0f, 3.0f, -6.0f, 3.0f, 0.0f, -3.0f, 3.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);
    protected PMatrix3D bezierDrawMatrix;
    protected boolean curveInited = false;
    protected int curveDetail = 20;
    public float curveTightness = 0.0f;
    protected PMatrix3D curveBasisMatrix;
    protected PMatrix3D curveDrawMatrix;
    protected PMatrix3D bezierBasisInverse;
    protected PMatrix3D curveToBezierMatrix;
    protected float[][] curveVertices;
    protected int curveVertexCount;
    protected static final float[] sinLUT = new float[720];
    protected static final float[] cosLUT = new float[720];
    protected static final float SINCOS_PRECISION = 0.5f;
    protected static final int SINCOS_LENGTH = 720;
    protected float textX;
    protected float textY;
    protected float textZ;
    protected char[] textBuffer = new char[8192];
    protected char[] textWidthBuffer = new char[8192];
    protected int textBreakCount;
    protected int[] textBreakStart;
    protected int[] textBreakStop;
    public boolean edge = true;
    protected static final int NORMAL_MODE_AUTO = 0;
    protected static final int NORMAL_MODE_SHAPE = 1;
    protected static final int NORMAL_MODE_VERTEX = 2;
    protected int normalMode;
    protected boolean autoNormal;
    public float normalX;
    public float normalY;
    public float normalZ;
    public int textureMode;
    public float textureU;
    public float textureV;
    public PImage textureImage;
    float[] sphereX;
    float[] sphereY;
    float[] sphereZ;
    public int sphereDetailU = 0;
    public int sphereDetailV = 0;
    static float[] lerpColorHSB1;
    static float[] lerpColorHSB2;
    protected static HashMap<String, Object> warnings;

    public void setParent(PApplet pApplet) {
        this.parent = pApplet;
    }

    public void setPrimary(boolean bl) {
        this.primarySurface = bl;
        if (this.primarySurface) {
            this.format = 1;
        }
    }

    public void setPath(String string) {
        this.path = string;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        this.allocate();
        this.reapplySettings();
    }

    protected void allocate() {
    }

    public void dispose() {
    }

    public boolean canDraw() {
        return true;
    }

    public void beginDraw() {
    }

    public void endDraw() {
    }

    public void flush() {
    }

    protected void checkSettings() {
        if (!this.settingsInited) {
            this.defaultSettings();
        }
    }

    protected void defaultSettings() {
        this.noSmooth();
        this.colorMode(1, 255.0f);
        this.fill(255);
        this.stroke(0);
        this.strokeWeight(1.0f);
        this.strokeJoin(8);
        this.strokeCap(2);
        this.shape = 0;
        this.rectMode(0);
        this.ellipseMode(3);
        this.autoNormal = true;
        this.textFont = null;
        this.textSize = 12.0f;
        this.textLeading = 14.0f;
        this.textAlign = 37;
        this.textMode = 4;
        if (this.primarySurface) {
            this.background(this.backgroundColor);
        }
        this.settingsInited = true;
    }

    protected void reapplySettings() {
        if (!this.settingsInited) {
            return;
        }
        this.colorMode(this.colorMode, this.colorModeX, this.colorModeY, this.colorModeZ);
        if (this.fill) {
            this.fill(this.fillColor);
        } else {
            this.noFill();
        }
        if (this.stroke) {
            this.stroke(this.strokeColor);
            this.strokeWeight(this.strokeWeight);
            this.strokeCap(this.strokeCap);
            this.strokeJoin(this.strokeJoin);
        } else {
            this.noStroke();
        }
        if (this.tint) {
            this.tint(this.tintColor);
        } else {
            this.noTint();
        }
        if (this.smooth) {
            this.smooth();
        } else {
            this.noSmooth();
        }
        if (this.textFont != null) {
            float f = this.textLeading;
            this.textFont(this.textFont, this.textSize);
            this.textLeading(f);
        }
        this.textMode(this.textMode);
        this.textAlign(this.textAlign, this.textAlignY);
        this.background(this.backgroundColor);
    }

    public void hint(int n) {
        if (n > 0) {
            this.hints[n] = true;
        } else {
            this.hints[-n] = false;
        }
    }

    public boolean hintEnabled(int n) {
        if (n > 0) {
            return this.hints[n];
        }
        return this.hints[-n];
    }

    public void beginShape() {
        this.beginShape(20);
    }

    public void beginShape(int n) {
        this.shape = n;
    }

    public void edge(boolean bl) {
        this.edge = bl;
    }

    public void normal(float f, float f2, float f3) {
        this.normalX = f;
        this.normalY = f2;
        this.normalZ = f3;
        if (this.shape != 0) {
            if (this.normalMode == 0) {
                this.normalMode = 1;
            } else if (this.normalMode == 1) {
                this.normalMode = 2;
            }
        }
    }

    public void textureMode(int n) {
        this.textureMode = n;
    }

    public void texture(PImage pImage) {
        this.textureImage = pImage;
    }

    public void noTexture() {
        this.textureImage = null;
    }

    protected void vertexCheck() {
        if (this.vertexCount == this.vertices.length) {
            float[][] fArray = new float[this.vertexCount << 1][37];
            System.arraycopy(this.vertices, 0, fArray, 0, this.vertexCount);
            this.vertices = fArray;
        }
    }

    public void vertex(float f, float f2) {
        boolean bl;
        this.vertexCheck();
        float[] fArray = this.vertices[this.vertexCount];
        this.curveVertexCount = 0;
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = 0.0f;
        fArray[12] = this.edge ? 1.0f : 0.0f;
        boolean bl2 = bl = this.textureImage != null;
        if (this.fill || bl) {
            if (!bl) {
                fArray[3] = this.fillR;
                fArray[4] = this.fillG;
                fArray[5] = this.fillB;
                fArray[6] = this.fillA;
            } else if (this.tint) {
                fArray[3] = this.tintR;
                fArray[4] = this.tintG;
                fArray[5] = this.tintB;
                fArray[6] = this.tintA;
            } else {
                fArray[3] = 1.0f;
                fArray[4] = 1.0f;
                fArray[5] = 1.0f;
                fArray[6] = 1.0f;
            }
        }
        if (this.stroke) {
            fArray[13] = this.strokeR;
            fArray[14] = this.strokeG;
            fArray[15] = this.strokeB;
            fArray[16] = this.strokeA;
            fArray[17] = this.strokeWeight;
        }
        if (bl) {
            fArray[7] = this.textureU;
            fArray[8] = this.textureV;
        }
        if (this.autoNormal) {
            float f3 = this.normalX * this.normalX + this.normalY * this.normalY + this.normalZ * this.normalZ;
            if (f3 < 1.0E-4f) {
                fArray[36] = 0.0f;
            } else {
                if (Math.abs(f3 - 1.0f) > 1.0E-4f) {
                    float f4 = PApplet.sqrt(f3);
                    this.normalX /= f4;
                    this.normalY /= f4;
                    this.normalZ /= f4;
                }
                fArray[36] = 1.0f;
            }
        } else {
            fArray[36] = 1.0f;
        }
        ++this.vertexCount;
    }

    public void vertex(float f, float f2, float f3) {
        boolean bl;
        float[] fArray;
        this.vertexCheck();
        float[] fArray2 = this.vertices[this.vertexCount];
        if (this.shape == 20 && this.vertexCount > 0 && Math.abs((fArray = this.vertices[this.vertexCount - 1])[0] - f) < 1.0E-4f && Math.abs(fArray[1] - f2) < 1.0E-4f && Math.abs(fArray[2] - f3) < 1.0E-4f) {
            return;
        }
        this.curveVertexCount = 0;
        fArray2[0] = f;
        fArray2[1] = f2;
        fArray2[2] = f3;
        fArray2[12] = this.edge ? 1.0f : 0.0f;
        boolean bl2 = bl = this.textureImage != null;
        if (this.fill || bl) {
            if (!bl) {
                fArray2[3] = this.fillR;
                fArray2[4] = this.fillG;
                fArray2[5] = this.fillB;
                fArray2[6] = this.fillA;
            } else if (this.tint) {
                fArray2[3] = this.tintR;
                fArray2[4] = this.tintG;
                fArray2[5] = this.tintB;
                fArray2[6] = this.tintA;
            } else {
                fArray2[3] = 1.0f;
                fArray2[4] = 1.0f;
                fArray2[5] = 1.0f;
                fArray2[6] = 1.0f;
            }
            fArray2[25] = this.ambientR;
            fArray2[26] = this.ambientG;
            fArray2[27] = this.ambientB;
            fArray2[28] = this.specularR;
            fArray2[29] = this.specularG;
            fArray2[30] = this.specularB;
            fArray2[31] = this.shininess;
            fArray2[32] = this.emissiveR;
            fArray2[33] = this.emissiveG;
            fArray2[34] = this.emissiveB;
        }
        if (this.stroke) {
            fArray2[13] = this.strokeR;
            fArray2[14] = this.strokeG;
            fArray2[15] = this.strokeB;
            fArray2[16] = this.strokeA;
            fArray2[17] = this.strokeWeight;
        }
        if (bl) {
            fArray2[7] = this.textureU;
            fArray2[8] = this.textureV;
        }
        if (this.autoNormal) {
            float f4 = this.normalX * this.normalX + this.normalY * this.normalY + this.normalZ * this.normalZ;
            if (f4 < 1.0E-4f) {
                fArray2[36] = 0.0f;
            } else {
                if (Math.abs(f4 - 1.0f) > 1.0E-4f) {
                    float f5 = PApplet.sqrt(f4);
                    this.normalX /= f5;
                    this.normalY /= f5;
                    this.normalZ /= f5;
                }
                fArray2[36] = 1.0f;
            }
        } else {
            fArray2[36] = 1.0f;
        }
        fArray2[9] = this.normalX;
        fArray2[10] = this.normalY;
        fArray2[11] = this.normalZ;
        fArray2[35] = 0.0f;
        ++this.vertexCount;
    }

    public void vertex(float[] fArray) {
        this.vertexCheck();
        this.curveVertexCount = 0;
        float[] fArray2 = this.vertices[this.vertexCount];
        System.arraycopy(fArray, 0, fArray2, 0, 37);
        ++this.vertexCount;
    }

    public void vertex(float f, float f2, float f3, float f4) {
        this.vertexTexture(f3, f4);
        this.vertex(f, f2);
    }

    public void vertex(float f, float f2, float f3, float f4, float f5) {
        this.vertexTexture(f4, f5);
        this.vertex(f, f2, f3);
    }

    protected void vertexTexture(float f, float f2) {
        if (this.textureImage == null) {
            throw new RuntimeException("You must first call texture() before using u and v coordinates with vertex()");
        }
        if (this.textureMode == 2) {
            f /= (float)this.textureImage.width;
            f2 /= (float)this.textureImage.height;
        }
        this.textureU = f;
        this.textureV = f2;
        if (this.textureU < 0.0f) {
            this.textureU = 0.0f;
        } else if (this.textureU > 1.0f) {
            this.textureU = 1.0f;
        }
        if (this.textureV < 0.0f) {
            this.textureV = 0.0f;
        } else if (this.textureV > 1.0f) {
            this.textureV = 1.0f;
        }
    }

    public void breakShape() {
        PGraphics.showWarning("This renderer cannot currently handle concave shapes, or shapes with holes.");
    }

    public void endShape() {
        this.endShape(1);
    }

    public void endShape(int n) {
    }

    protected void bezierVertexCheck() {
        if (this.shape == 0 || this.shape != 20) {
            throw new RuntimeException("beginShape() or beginShape(POLYGON) must be used before bezierVertex() or quadraticVertex()");
        }
        if (this.vertexCount == 0) {
            throw new RuntimeException("vertex() must be used at least oncebefore bezierVertex() or quadraticVertex()");
        }
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        this.bezierInitCheck();
        this.bezierVertexCheck();
        PMatrix3D pMatrix3D = this.bezierDrawMatrix;
        float[] fArray = this.vertices[this.vertexCount - 1];
        float f7 = fArray[0];
        float f8 = fArray[1];
        float f9 = pMatrix3D.m10 * f7 + pMatrix3D.m11 * f + pMatrix3D.m12 * f3 + pMatrix3D.m13 * f5;
        float f10 = pMatrix3D.m20 * f7 + pMatrix3D.m21 * f + pMatrix3D.m22 * f3 + pMatrix3D.m23 * f5;
        float f11 = pMatrix3D.m30 * f7 + pMatrix3D.m31 * f + pMatrix3D.m32 * f3 + pMatrix3D.m33 * f5;
        float f12 = pMatrix3D.m10 * f8 + pMatrix3D.m11 * f2 + pMatrix3D.m12 * f4 + pMatrix3D.m13 * f6;
        float f13 = pMatrix3D.m20 * f8 + pMatrix3D.m21 * f2 + pMatrix3D.m22 * f4 + pMatrix3D.m23 * f6;
        float f14 = pMatrix3D.m30 * f8 + pMatrix3D.m31 * f2 + pMatrix3D.m32 * f4 + pMatrix3D.m33 * f6;
        for (int i = 0; i < this.bezierDetail; ++i) {
            f9 += f10;
            f10 += f11;
            f13 += f14;
            this.vertex(f7 += f9, f8 += (f12 += f13));
        }
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.bezierInitCheck();
        this.bezierVertexCheck();
        PMatrix3D pMatrix3D = this.bezierDrawMatrix;
        float[] fArray = this.vertices[this.vertexCount - 1];
        float f10 = fArray[0];
        float f11 = fArray[1];
        float f12 = fArray[2];
        float f13 = pMatrix3D.m10 * f10 + pMatrix3D.m11 * f + pMatrix3D.m12 * f4 + pMatrix3D.m13 * f7;
        float f14 = pMatrix3D.m20 * f10 + pMatrix3D.m21 * f + pMatrix3D.m22 * f4 + pMatrix3D.m23 * f7;
        float f15 = pMatrix3D.m30 * f10 + pMatrix3D.m31 * f + pMatrix3D.m32 * f4 + pMatrix3D.m33 * f7;
        float f16 = pMatrix3D.m10 * f11 + pMatrix3D.m11 * f2 + pMatrix3D.m12 * f5 + pMatrix3D.m13 * f8;
        float f17 = pMatrix3D.m20 * f11 + pMatrix3D.m21 * f2 + pMatrix3D.m22 * f5 + pMatrix3D.m23 * f8;
        float f18 = pMatrix3D.m30 * f11 + pMatrix3D.m31 * f2 + pMatrix3D.m32 * f5 + pMatrix3D.m33 * f8;
        float f19 = pMatrix3D.m10 * f12 + pMatrix3D.m11 * f3 + pMatrix3D.m12 * f6 + pMatrix3D.m13 * f9;
        float f20 = pMatrix3D.m20 * f12 + pMatrix3D.m21 * f3 + pMatrix3D.m22 * f6 + pMatrix3D.m23 * f9;
        float f21 = pMatrix3D.m30 * f12 + pMatrix3D.m31 * f3 + pMatrix3D.m32 * f6 + pMatrix3D.m33 * f9;
        for (int i = 0; i < this.bezierDetail; ++i) {
            f10 += f13;
            f13 += f14;
            f14 += f15;
            f16 += f17;
            f17 += f18;
            f20 += f21;
            this.vertex(f10, f11 += f16, f12 += (f19 += f20));
        }
    }

    public void quadraticVertex(float f, float f2, float f3, float f4) {
        float[] fArray = this.vertices[this.vertexCount - 1];
        float f5 = fArray[0];
        float f6 = fArray[1];
        this.bezierVertex(f5 + (f - f5) * 2.0f / 3.0f, f6 + (f2 - f6) * 2.0f / 3.0f, f3 + (f - f3) * 2.0f / 3.0f, f4 + (f2 - f4) * 2.0f / 3.0f, f3, f4);
    }

    public void quadraticVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        float[] fArray = this.vertices[this.vertexCount - 1];
        float f7 = fArray[0];
        float f8 = fArray[1];
        float f9 = fArray[2];
        this.bezierVertex(f7 + (f - f7) * 2.0f / 3.0f, f8 + (f2 - f8) * 2.0f / 3.0f, f9 + (f3 - f9) * 2.0f / 3.0f, f4 + (f - f4) * 2.0f / 3.0f, f5 + (f2 - f5) * 2.0f / 3.0f, f6 + (f3 - f6) * 2.0f / 3.0f, f4, f5, f6);
    }

    protected void curveVertexCheck() {
        if (this.shape != 20) {
            throw new RuntimeException("You must use beginShape() or beginShape(POLYGON) before curveVertex()");
        }
        if (this.curveVertices == null) {
            this.curveVertices = new float[128][3];
        }
        if (this.curveVertexCount == this.curveVertices.length) {
            float[][] fArray = new float[this.curveVertexCount << 1][3];
            System.arraycopy(this.curveVertices, 0, fArray, 0, this.curveVertexCount);
            this.curveVertices = fArray;
        }
        this.curveInitCheck();
    }

    public void curveVertex(float f, float f2) {
        this.curveVertexCheck();
        float[] fArray = this.curveVertices[this.curveVertexCount];
        fArray[0] = f;
        fArray[1] = f2;
        ++this.curveVertexCount;
        if (this.curveVertexCount > 3) {
            this.curveVertexSegment(this.curveVertices[this.curveVertexCount - 4][0], this.curveVertices[this.curveVertexCount - 4][1], this.curveVertices[this.curveVertexCount - 3][0], this.curveVertices[this.curveVertexCount - 3][1], this.curveVertices[this.curveVertexCount - 2][0], this.curveVertices[this.curveVertexCount - 2][1], this.curveVertices[this.curveVertexCount - 1][0], this.curveVertices[this.curveVertexCount - 1][1]);
        }
    }

    public void curveVertex(float f, float f2, float f3) {
        this.curveVertexCheck();
        float[] fArray = this.curveVertices[this.curveVertexCount];
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3;
        ++this.curveVertexCount;
        if (this.curveVertexCount > 3) {
            this.curveVertexSegment(this.curveVertices[this.curveVertexCount - 4][0], this.curveVertices[this.curveVertexCount - 4][1], this.curveVertices[this.curveVertexCount - 4][2], this.curveVertices[this.curveVertexCount - 3][0], this.curveVertices[this.curveVertexCount - 3][1], this.curveVertices[this.curveVertexCount - 3][2], this.curveVertices[this.curveVertexCount - 2][0], this.curveVertices[this.curveVertexCount - 2][1], this.curveVertices[this.curveVertexCount - 2][2], this.curveVertices[this.curveVertexCount - 1][0], this.curveVertices[this.curveVertexCount - 1][1], this.curveVertices[this.curveVertexCount - 1][2]);
        }
    }

    protected void curveVertexSegment(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = f3;
        float f10 = f4;
        PMatrix3D pMatrix3D = this.curveDrawMatrix;
        float f11 = pMatrix3D.m10 * f + pMatrix3D.m11 * f3 + pMatrix3D.m12 * f5 + pMatrix3D.m13 * f7;
        float f12 = pMatrix3D.m20 * f + pMatrix3D.m21 * f3 + pMatrix3D.m22 * f5 + pMatrix3D.m23 * f7;
        float f13 = pMatrix3D.m30 * f + pMatrix3D.m31 * f3 + pMatrix3D.m32 * f5 + pMatrix3D.m33 * f7;
        float f14 = pMatrix3D.m10 * f2 + pMatrix3D.m11 * f4 + pMatrix3D.m12 * f6 + pMatrix3D.m13 * f8;
        float f15 = pMatrix3D.m20 * f2 + pMatrix3D.m21 * f4 + pMatrix3D.m22 * f6 + pMatrix3D.m23 * f8;
        float f16 = pMatrix3D.m30 * f2 + pMatrix3D.m31 * f4 + pMatrix3D.m32 * f6 + pMatrix3D.m33 * f8;
        int n = this.curveVertexCount;
        this.vertex(f9, f10);
        for (int i = 0; i < this.curveDetail; ++i) {
            f11 += f12;
            f12 += f13;
            f15 += f16;
            this.vertex(f9 += f11, f10 += (f14 += f15));
        }
        this.curveVertexCount = n;
    }

    protected void curveVertexSegment(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        float f13 = f4;
        float f14 = f5;
        float f15 = f6;
        PMatrix3D pMatrix3D = this.curveDrawMatrix;
        float f16 = pMatrix3D.m10 * f + pMatrix3D.m11 * f4 + pMatrix3D.m12 * f7 + pMatrix3D.m13 * f10;
        float f17 = pMatrix3D.m20 * f + pMatrix3D.m21 * f4 + pMatrix3D.m22 * f7 + pMatrix3D.m23 * f10;
        float f18 = pMatrix3D.m30 * f + pMatrix3D.m31 * f4 + pMatrix3D.m32 * f7 + pMatrix3D.m33 * f10;
        float f19 = pMatrix3D.m10 * f2 + pMatrix3D.m11 * f5 + pMatrix3D.m12 * f8 + pMatrix3D.m13 * f11;
        float f20 = pMatrix3D.m20 * f2 + pMatrix3D.m21 * f5 + pMatrix3D.m22 * f8 + pMatrix3D.m23 * f11;
        float f21 = pMatrix3D.m30 * f2 + pMatrix3D.m31 * f5 + pMatrix3D.m32 * f8 + pMatrix3D.m33 * f11;
        int n = this.curveVertexCount;
        float f22 = pMatrix3D.m10 * f3 + pMatrix3D.m11 * f6 + pMatrix3D.m12 * f9 + pMatrix3D.m13 * f12;
        float f23 = pMatrix3D.m20 * f3 + pMatrix3D.m21 * f6 + pMatrix3D.m22 * f9 + pMatrix3D.m23 * f12;
        float f24 = pMatrix3D.m30 * f3 + pMatrix3D.m31 * f6 + pMatrix3D.m32 * f9 + pMatrix3D.m33 * f12;
        this.vertex(f13, f14, f15);
        for (int i = 0; i < this.curveDetail; ++i) {
            f13 += f16;
            f16 += f17;
            f17 += f18;
            f19 += f20;
            f20 += f21;
            f23 += f24;
            this.vertex(f13, f14 += f19, f15 += (f22 += f23));
        }
        this.curveVertexCount = n;
    }

    public void point(float f, float f2) {
        this.beginShape(2);
        this.vertex(f, f2);
        this.endShape();
    }

    public void point(float f, float f2, float f3) {
        this.beginShape(2);
        this.vertex(f, f2, f3);
        this.endShape();
    }

    public void line(float f, float f2, float f3, float f4) {
        this.beginShape(4);
        this.vertex(f, f2);
        this.vertex(f3, f4);
        this.endShape();
    }

    public void line(float f, float f2, float f3, float f4, float f5, float f6) {
        this.beginShape(4);
        this.vertex(f, f2, f3);
        this.vertex(f4, f5, f6);
        this.endShape();
    }

    public void triangle(float f, float f2, float f3, float f4, float f5, float f6) {
        this.beginShape(9);
        this.vertex(f, f2);
        this.vertex(f3, f4);
        this.vertex(f5, f6);
        this.endShape();
    }

    public void quad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.beginShape(16);
        this.vertex(f, f2);
        this.vertex(f3, f4);
        this.vertex(f5, f6);
        this.vertex(f7, f8);
        this.endShape();
    }

    public void rectMode(int n) {
        this.rectMode = n;
    }

    public void rect(float f, float f2, float f3, float f4) {
        float f5;
        switch (this.rectMode) {
            case 1: {
                break;
            }
            case 0: {
                f3 += f;
                f4 += f2;
                break;
            }
            case 2: {
                float f6 = f3;
                float f7 = f4;
                f3 = f + f6;
                f4 = f2 + f7;
                f -= f6;
                f2 -= f7;
                break;
            }
            case 3: {
                float f8 = f3 / 2.0f;
                float f9 = f4 / 2.0f;
                f3 = f + f8;
                f4 = f2 + f9;
                f -= f8;
                f2 -= f9;
            }
        }
        if (f > f3) {
            f5 = f;
            f = f3;
            f3 = f5;
        }
        if (f2 > f4) {
            f5 = f2;
            f2 = f4;
            f4 = f5;
        }
        this.rectImpl(f, f2, f3, f4);
    }

    protected void rectImpl(float f, float f2, float f3, float f4) {
        this.quad(f, f2, f3, f2, f3, f4, f, f4);
    }

    public void rect(float f, float f2, float f3, float f4, float f5) {
        this.rect(f, f2, f3, f4, f5, f5, f5, f5);
    }

    public void rect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9;
        switch (this.rectMode) {
            case 1: {
                break;
            }
            case 0: {
                f3 += f;
                f4 += f2;
                break;
            }
            case 2: {
                float f10 = f3;
                float f11 = f4;
                f3 = f + f10;
                f4 = f2 + f11;
                f -= f10;
                f2 -= f11;
                break;
            }
            case 3: {
                float f12 = f3 / 2.0f;
                float f13 = f4 / 2.0f;
                f3 = f + f12;
                f4 = f2 + f13;
                f -= f12;
                f2 -= f13;
            }
        }
        if (f > f3) {
            f9 = f;
            f = f3;
            f3 = f9;
        }
        if (f2 > f4) {
            f9 = f2;
            f2 = f4;
            f4 = f9;
        }
        if (f5 > (f9 = PApplet.min((f3 - f) / 2.0f, (f4 - f2) / 2.0f))) {
            f5 = f9;
        }
        if (f6 > f9) {
            f6 = f9;
        }
        if (f7 > f9) {
            f7 = f9;
        }
        if (f8 > f9) {
            f8 = f9;
        }
        this.rectImpl(f, f2, f3, f4, f5, f6, f7, f8);
    }

    protected void rectImpl(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.beginShape();
        if (f6 != 0.0f) {
            this.vertex(f3 - f6, f2);
            this.quadraticVertex(f3, f2, f3, f2 + f6);
        } else {
            this.vertex(f3, f2);
        }
        if (f7 != 0.0f) {
            this.vertex(f3, f4 - f7);
            this.quadraticVertex(f3, f4, f3 - f7, f4);
        } else {
            this.vertex(f3, f4);
        }
        if (f8 != 0.0f) {
            this.vertex(f + f8, f4);
            this.quadraticVertex(f, f4, f, f4 - f8);
        } else {
            this.vertex(f, f4);
        }
        if (f5 != 0.0f) {
            this.vertex(f, f2 + f5);
            this.quadraticVertex(f, f2, f + f5, f2);
        } else {
            this.vertex(f, f2);
        }
        this.endShape(2);
    }

    public void ellipseMode(int n) {
        this.ellipseMode = n;
    }

    public void ellipse(float f, float f2, float f3, float f4) {
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        if (this.ellipseMode == 1) {
            f7 = f3 - f;
            f8 = f4 - f2;
        } else if (this.ellipseMode == 2) {
            f5 = f - f3;
            f6 = f2 - f4;
            f7 = f3 * 2.0f;
            f8 = f4 * 2.0f;
        } else if (this.ellipseMode == 3) {
            f5 = f - f3 / 2.0f;
            f6 = f2 - f4 / 2.0f;
        }
        if (f7 < 0.0f) {
            f5 += f7;
            f7 = -f7;
        }
        if (f8 < 0.0f) {
            f6 += f8;
            f8 = -f8;
        }
        this.ellipseImpl(f5, f6, f7, f8);
    }

    protected void ellipseImpl(float f, float f2, float f3, float f4) {
    }

    public void arc(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f;
        float f8 = f2;
        float f9 = f3;
        float f10 = f4;
        if (this.ellipseMode == 1) {
            f9 = f3 - f;
            f10 = f4 - f2;
        } else if (this.ellipseMode == 2) {
            f7 = f - f3;
            f8 = f2 - f4;
            f9 = f3 * 2.0f;
            f10 = f4 * 2.0f;
        } else if (this.ellipseMode == 3) {
            f7 = f - f3 / 2.0f;
            f8 = f2 - f4 / 2.0f;
        }
        if (Float.isInfinite(f5) || Float.isInfinite(f6)) {
            return;
        }
        if (f6 < f5) {
            return;
        }
        while (f5 < 0.0f) {
            f5 += (float)Math.PI * 2;
            f6 += (float)Math.PI * 2;
        }
        if (f6 - f5 > (float)Math.PI * 2) {
            f5 = 0.0f;
            f6 = (float)Math.PI * 2;
        }
        this.arcImpl(f7, f8, f9, f10, f5, f6);
    }

    protected void arcImpl(float f, float f2, float f3, float f4, float f5, float f6) {
    }

    public void box(float f) {
        this.box(f, f, f);
    }

    public void box(float f, float f2, float f3) {
        float f4 = -f / 2.0f;
        float f5 = f / 2.0f;
        float f6 = -f2 / 2.0f;
        float f7 = f2 / 2.0f;
        float f8 = -f3 / 2.0f;
        float f9 = f3 / 2.0f;
        this.beginShape(16);
        this.normal(0.0f, 0.0f, 1.0f);
        this.vertex(f4, f6, f8);
        this.vertex(f5, f6, f8);
        this.vertex(f5, f7, f8);
        this.vertex(f4, f7, f8);
        this.normal(1.0f, 0.0f, 0.0f);
        this.vertex(f5, f6, f8);
        this.vertex(f5, f6, f9);
        this.vertex(f5, f7, f9);
        this.vertex(f5, f7, f8);
        this.normal(0.0f, 0.0f, -1.0f);
        this.vertex(f5, f6, f9);
        this.vertex(f4, f6, f9);
        this.vertex(f4, f7, f9);
        this.vertex(f5, f7, f9);
        this.normal(-1.0f, 0.0f, 0.0f);
        this.vertex(f4, f6, f9);
        this.vertex(f4, f6, f8);
        this.vertex(f4, f7, f8);
        this.vertex(f4, f7, f9);
        this.normal(0.0f, 1.0f, 0.0f);
        this.vertex(f4, f6, f9);
        this.vertex(f5, f6, f9);
        this.vertex(f5, f6, f8);
        this.vertex(f4, f6, f8);
        this.normal(0.0f, -1.0f, 0.0f);
        this.vertex(f4, f7, f8);
        this.vertex(f5, f7, f8);
        this.vertex(f5, f7, f9);
        this.vertex(f4, f7, f9);
        this.endShape();
    }

    public void sphereDetail(int n) {
        this.sphereDetail(n, n);
    }

    public void sphereDetail(int n, int n2) {
        float f;
        int n3;
        if (n < 3) {
            n = 3;
        }
        if (n2 < 2) {
            n2 = 2;
        }
        if (n == this.sphereDetailU && n2 == this.sphereDetailV) {
            return;
        }
        float f2 = 720.0f / (float)n;
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        for (n3 = 0; n3 < n; ++n3) {
            fArray[n3] = cosLUT[(int)((float)n3 * f2) % 720];
            fArray2[n3] = sinLUT[(int)((float)n3 * f2) % 720];
        }
        n3 = n * (n2 - 1) + 2;
        int n4 = 0;
        this.sphereX = new float[n3];
        this.sphereY = new float[n3];
        this.sphereZ = new float[n3];
        float f3 = f = 360.0f / (float)n2;
        for (int i = 1; i < n2; ++i) {
            float f4 = sinLUT[(int)f3 % 720];
            float f5 = -cosLUT[(int)f3 % 720];
            for (int j = 0; j < n; ++j) {
                this.sphereX[n4] = fArray[j] * f4;
                this.sphereY[n4] = f5;
                this.sphereZ[n4++] = fArray2[j] * f4;
            }
            f3 += f;
        }
        this.sphereDetailU = n;
        this.sphereDetailV = n2;
    }

    public void sphere(float f) {
        int n;
        int n2;
        int n3;
        if (this.sphereDetailU < 3 || this.sphereDetailV < 2) {
            this.sphereDetail(30);
        }
        this.edge(false);
        this.beginShape(10);
        for (n3 = 0; n3 < this.sphereDetailU; ++n3) {
            this.normal(0.0f, -1.0f, 0.0f);
            this.vertex(0.0f, -f, 0.0f);
            this.normal(this.sphereX[n3], this.sphereY[n3], this.sphereZ[n3]);
            this.vertex(f * this.sphereX[n3], f * this.sphereY[n3], f * this.sphereZ[n3]);
        }
        this.normal(0.0f, -1.0f, 0.0f);
        this.vertex(0.0f, -1.0f, 0.0f);
        this.normal(this.sphereX[0], this.sphereY[0], this.sphereZ[0]);
        this.vertex(f * this.sphereX[0], f * this.sphereY[0], f * this.sphereZ[0]);
        this.endShape();
        int n4 = 0;
        for (n2 = 2; n2 < this.sphereDetailV; ++n2) {
            int n5;
            n3 = n5 = n4;
            n = n4 += this.sphereDetailU;
            this.beginShape(10);
            for (int i = 0; i < this.sphereDetailU; ++i) {
                this.normal(this.sphereX[n3], this.sphereY[n3], this.sphereZ[n3]);
                this.vertex(f * this.sphereX[n3], f * this.sphereY[n3], f * this.sphereZ[n3++]);
                this.normal(this.sphereX[n], this.sphereY[n], this.sphereZ[n]);
                this.vertex(f * this.sphereX[n], f * this.sphereY[n], f * this.sphereZ[n++]);
            }
            n3 = n5;
            n = n4;
            this.normal(this.sphereX[n3], this.sphereY[n3], this.sphereZ[n3]);
            this.vertex(f * this.sphereX[n3], f * this.sphereY[n3], this.sphereZ[n3]);
            this.normal(this.sphereX[n], this.sphereY[n], this.sphereZ[n]);
            this.vertex(f * this.sphereX[n], f * this.sphereY[n], f * this.sphereZ[n]);
            this.endShape();
        }
        this.beginShape(10);
        for (n2 = 0; n2 < this.sphereDetailU; ++n2) {
            n = n4 + n2;
            this.normal(this.sphereX[n], this.sphereY[n], this.sphereZ[n]);
            this.vertex(f * this.sphereX[n], f * this.sphereY[n], f * this.sphereZ[n]);
            this.normal(0.0f, 1.0f, 0.0f);
            this.vertex(0.0f, f, 0.0f);
        }
        this.normal(this.sphereX[n4], this.sphereY[n4], this.sphereZ[n4]);
        this.vertex(f * this.sphereX[n4], f * this.sphereY[n4], f * this.sphereZ[n4]);
        this.normal(0.0f, 1.0f, 0.0f);
        this.vertex(0.0f, f, 0.0f);
        this.endShape();
        this.edge(true);
    }

    public float bezierPoint(float f, float f2, float f3, float f4, float f5) {
        float f6 = 1.0f - f5;
        return f * f6 * f6 * f6 + 3.0f * f2 * f5 * f6 * f6 + 3.0f * f3 * f5 * f5 * f6 + f4 * f5 * f5 * f5;
    }

    public float bezierTangent(float f, float f2, float f3, float f4, float f5) {
        return 3.0f * f5 * f5 * (-f + 3.0f * f2 - 3.0f * f3 + f4) + 6.0f * f5 * (f - 2.0f * f2 + f3) + 3.0f * (-f + f2);
    }

    protected void bezierInitCheck() {
        if (!this.bezierInited) {
            this.bezierInit();
        }
    }

    protected void bezierInit() {
        this.bezierDetail(this.bezierDetail);
        this.bezierInited = true;
    }

    public void bezierDetail(int n) {
        this.bezierDetail = n;
        if (this.bezierDrawMatrix == null) {
            this.bezierDrawMatrix = new PMatrix3D();
        }
        this.splineForward(n, this.bezierDrawMatrix);
        this.bezierDrawMatrix.apply(this.bezierBasisMatrix);
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.beginShape();
        this.vertex(f, f2);
        this.bezierVertex(f3, f4, f5, f6, f7, f8);
        this.endShape();
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.beginShape();
        this.vertex(f, f2, f3);
        this.bezierVertex(f4, f5, f6, f7, f8, f9, f10, f11, f12);
        this.endShape();
    }

    public float curvePoint(float f, float f2, float f3, float f4, float f5) {
        this.curveInitCheck();
        float f6 = f5 * f5;
        float f7 = f5 * f6;
        PMatrix3D pMatrix3D = this.curveBasisMatrix;
        return f * (f7 * pMatrix3D.m00 + f6 * pMatrix3D.m10 + f5 * pMatrix3D.m20 + pMatrix3D.m30) + f2 * (f7 * pMatrix3D.m01 + f6 * pMatrix3D.m11 + f5 * pMatrix3D.m21 + pMatrix3D.m31) + f3 * (f7 * pMatrix3D.m02 + f6 * pMatrix3D.m12 + f5 * pMatrix3D.m22 + pMatrix3D.m32) + f4 * (f7 * pMatrix3D.m03 + f6 * pMatrix3D.m13 + f5 * pMatrix3D.m23 + pMatrix3D.m33);
    }

    public float curveTangent(float f, float f2, float f3, float f4, float f5) {
        this.curveInitCheck();
        float f6 = f5 * f5 * 3.0f;
        float f7 = f5 * 2.0f;
        PMatrix3D pMatrix3D = this.curveBasisMatrix;
        return f * (f6 * pMatrix3D.m00 + f7 * pMatrix3D.m10 + pMatrix3D.m20) + f2 * (f6 * pMatrix3D.m01 + f7 * pMatrix3D.m11 + pMatrix3D.m21) + f3 * (f6 * pMatrix3D.m02 + f7 * pMatrix3D.m12 + pMatrix3D.m22) + f4 * (f6 * pMatrix3D.m03 + f7 * pMatrix3D.m13 + pMatrix3D.m23);
    }

    public void curveDetail(int n) {
        this.curveDetail = n;
        this.curveInit();
    }

    public void curveTightness(float f) {
        this.curveTightness = f;
        this.curveInit();
    }

    protected void curveInitCheck() {
        if (!this.curveInited) {
            this.curveInit();
        }
    }

    protected void curveInit() {
        if (this.curveDrawMatrix == null) {
            this.curveBasisMatrix = new PMatrix3D();
            this.curveDrawMatrix = new PMatrix3D();
            this.curveInited = true;
        }
        float f = this.curveTightness;
        this.curveBasisMatrix.set((f - 1.0f) / 2.0f, (f + 3.0f) / 2.0f, (-3.0f - f) / 2.0f, (1.0f - f) / 2.0f, 1.0f - f, (-5.0f - f) / 2.0f, f + 2.0f, (f - 1.0f) / 2.0f, (f - 1.0f) / 2.0f, 0.0f, (1.0f - f) / 2.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        this.splineForward(this.curveDetail, this.curveDrawMatrix);
        if (this.bezierBasisInverse == null) {
            this.bezierBasisInverse = this.bezierBasisMatrix.get();
            this.bezierBasisInverse.invert();
            this.curveToBezierMatrix = new PMatrix3D();
        }
        this.curveToBezierMatrix.set(this.curveBasisMatrix);
        this.curveToBezierMatrix.preApply(this.bezierBasisInverse);
        this.curveDrawMatrix.apply(this.curveBasisMatrix);
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.beginShape();
        this.curveVertex(f, f2);
        this.curveVertex(f3, f4);
        this.curveVertex(f5, f6);
        this.curveVertex(f7, f8);
        this.endShape();
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.beginShape();
        this.curveVertex(f, f2, f3);
        this.curveVertex(f4, f5, f6);
        this.curveVertex(f7, f8, f9);
        this.curveVertex(f10, f11, f12);
        this.endShape();
    }

    protected void splineForward(int n, PMatrix3D pMatrix3D) {
        float f = 1.0f / (float)n;
        float f2 = f * f;
        float f3 = f2 * f;
        pMatrix3D.set(0.0f, 0.0f, 0.0f, 1.0f, f3, f2, f, 0.0f, 6.0f * f3, 2.0f * f2, 0.0f, 0.0f, 6.0f * f3, 0.0f, 0.0f, 0.0f);
    }

    public void smooth() {
        this.smooth = true;
    }

    public void noSmooth() {
        this.smooth = false;
    }

    public void imageMode(int n) {
        if (n != 0 && n != 1 && n != 3) {
            String string = "imageMode() only works with CORNER, CORNERS, or CENTER";
            throw new RuntimeException(string);
        }
        this.imageMode = n;
    }

    public void image(PImage pImage, float f, float f2) {
        if (pImage.width == -1 || pImage.height == -1) {
            return;
        }
        if (this.imageMode == 0 || this.imageMode == 1) {
            this.imageImpl(pImage, f, f2, f + (float)pImage.width, f2 + (float)pImage.height, 0, 0, pImage.width, pImage.height);
        } else if (this.imageMode == 3) {
            float f3 = f - (float)(pImage.width / 2);
            float f4 = f2 - (float)(pImage.height / 2);
            this.imageImpl(pImage, f3, f4, f3 + (float)pImage.width, f4 + (float)pImage.height, 0, 0, pImage.width, pImage.height);
        }
    }

    public void image(PImage pImage, float f, float f2, float f3, float f4) {
        this.image(pImage, f, f2, f3, f4, 0, 0, pImage.width, pImage.height);
    }

    public void image(PImage pImage, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        if (pImage.width == -1 || pImage.height == -1) {
            return;
        }
        if (this.imageMode == 0) {
            if (f3 < 0.0f) {
                f += f3;
                f3 = -f3;
            }
            if (f4 < 0.0f) {
                f2 += f4;
                f4 = -f4;
            }
            this.imageImpl(pImage, f, f2, f + f3, f2 + f4, n, n2, n3, n4);
        } else if (this.imageMode == 1) {
            float f5;
            if (f3 < f) {
                f5 = f;
                f = f3;
                f3 = f5;
            }
            if (f4 < f2) {
                f5 = f2;
                f2 = f4;
                f4 = f5;
            }
            this.imageImpl(pImage, f, f2, f3, f4, n, n2, n3, n4);
        } else if (this.imageMode == 3) {
            if (f3 < 0.0f) {
                f3 = -f3;
            }
            if (f4 < 0.0f) {
                f4 = -f4;
            }
            float f6 = f - f3 / 2.0f;
            float f7 = f2 - f4 / 2.0f;
            this.imageImpl(pImage, f6, f7, f6 + f3, f7 + f4, n, n2, n3, n4);
        }
    }

    protected void imageImpl(PImage pImage, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        boolean bl = this.stroke;
        int n5 = this.textureMode;
        this.stroke = false;
        this.textureMode = 2;
        this.beginShape(16);
        this.texture(pImage);
        this.vertex(f, f2, n, n2);
        this.vertex(f, f4, n, n4);
        this.vertex(f3, f4, n3, n4);
        this.vertex(f3, f2, n3, n2);
        this.endShape();
        this.stroke = bl;
        this.textureMode = n5;
    }

    public void shapeMode(int n) {
        this.shapeMode = n;
    }

    public void shape(PShape pShape) {
        if (pShape.isVisible()) {
            if (this.shapeMode == 3) {
                this.pushMatrix();
                this.translate(-pShape.getWidth() / 2.0f, -pShape.getHeight() / 2.0f);
            }
            pShape.draw(this);
            if (this.shapeMode == 3) {
                this.popMatrix();
            }
        }
    }

    public void shape(PShape pShape, float f, float f2) {
        if (pShape.isVisible()) {
            this.pushMatrix();
            if (this.shapeMode == 3) {
                this.translate(f - pShape.getWidth() / 2.0f, f2 - pShape.getHeight() / 2.0f);
            } else if (this.shapeMode == 0 || this.shapeMode == 1) {
                this.translate(f, f2);
            }
            pShape.draw(this);
            this.popMatrix();
        }
    }

    public void shape(PShape pShape, float f, float f2, float f3, float f4) {
        if (pShape.isVisible()) {
            this.pushMatrix();
            if (this.shapeMode == 3) {
                this.translate(f - f3 / 2.0f, f2 - f4 / 2.0f);
                this.scale(f3 / pShape.getWidth(), f4 / pShape.getHeight());
            } else if (this.shapeMode == 0) {
                this.translate(f, f2);
                this.scale(f3 / pShape.getWidth(), f4 / pShape.getHeight());
            } else if (this.shapeMode == 1) {
                this.translate(f, f2);
                this.scale((f3 -= f) / pShape.getWidth(), (f4 -= f2) / pShape.getHeight());
            }
            pShape.draw(this);
            this.popMatrix();
        }
    }

    public void textAlign(int n) {
        this.textAlign(n, 0);
    }

    public void textAlign(int n, int n2) {
        this.textAlign = n;
        this.textAlignY = n2;
    }

    public float textAscent() {
        if (this.textFont == null) {
            this.defaultFontOrDeath("textAscent");
        }
        return this.textFont.ascent() * this.textSize;
    }

    public float textDescent() {
        if (this.textFont == null) {
            this.defaultFontOrDeath("textDescent");
        }
        return this.textFont.descent() * this.textSize;
    }

    public void textFont(PFont pFont) {
        if (pFont != null) {
            this.textFont = pFont;
            if (this.hints[3]) {
                pFont.findFont();
            }
        } else {
            throw new RuntimeException("A null PFont was passed to textFont()");
        }
        this.textSize(pFont.size);
    }

    public void textFont(PFont pFont, float f) {
        this.textFont(pFont);
        this.textSize(f);
    }

    public void textLeading(float f) {
        this.textLeading = f;
    }

    public void textMode(int n) {
        if (n == 37 || n == 39) {
            PGraphics.showWarning("Since Processing beta, textMode() is now textAlign().");
            return;
        }
        if (n == 256) {
            PGraphics.showWarning("textMode(SCREEN) has been removed from Processing 2.0.");
        }
        if (this.textModeCheck(n)) {
            this.textMode = n;
        } else {
            String string = String.valueOf(n);
            switch (n) {
                case 4: {
                    string = "MODEL";
                    break;
                }
                case 5: {
                    string = "SHAPE";
                }
            }
            PGraphics.showWarning("textMode(" + string + ") is not supported by this renderer.");
        }
    }

    protected boolean textModeCheck(int n) {
        return true;
    }

    public void textSize(float f) {
        if (this.textFont == null) {
            this.defaultFontOrDeath("textSize", f);
        }
        this.textSize = f;
        this.textLeading = (this.textAscent() + this.textDescent()) * 1.275f;
    }

    public float textWidth(char c) {
        this.textWidthBuffer[0] = c;
        return this.textWidthImpl(this.textWidthBuffer, 0, 1);
    }

    public float textWidth(String string) {
        int n;
        int n2;
        if (this.textFont == null) {
            this.defaultFontOrDeath("textWidth");
        }
        if ((n2 = string.length()) > this.textWidthBuffer.length) {
            this.textWidthBuffer = new char[n2 + 10];
        }
        string.getChars(0, n2, this.textWidthBuffer, 0);
        float f = 0.0f;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (this.textWidthBuffer[n] != '\n') continue;
            f = Math.max(f, this.textWidthImpl(this.textWidthBuffer, n3, n));
            n3 = n + 1;
        }
        if (n3 < n2) {
            f = Math.max(f, this.textWidthImpl(this.textWidthBuffer, n3, n));
        }
        return f;
    }

    public float textWidth(char[] cArray, int n, int n2) {
        return this.textWidthImpl(cArray, n, n + n2);
    }

    protected float textWidthImpl(char[] cArray, int n, int n2) {
        float f = 0.0f;
        for (int i = n; i < n2; ++i) {
            f += this.textFont.width(cArray[i]) * this.textSize;
        }
        return f;
    }

    public void text(char c) {
        this.text(c, this.textX, this.textY, this.textZ);
    }

    public void text(char c, float f, float f2) {
        if (this.textFont == null) {
            this.defaultFontOrDeath("text");
        }
        if (this.textAlignY == 3) {
            f2 += this.textAscent() / 2.0f;
        } else if (this.textAlignY == 101) {
            f2 += this.textAscent();
        } else if (this.textAlignY == 102) {
            f2 -= this.textDescent();
        }
        this.textBuffer[0] = c;
        this.textLineAlignImpl(this.textBuffer, 0, 1, f, f2);
    }

    public void text(char c, float f, float f2, float f3) {
        if (f3 != 0.0f) {
            this.translate(0.0f, 0.0f, f3);
        }
        this.text(c, f, f2);
        this.textZ = f3;
        if (f3 != 0.0f) {
            this.translate(0.0f, 0.0f, -f3);
        }
    }

    public void text(String string) {
        this.text(string, this.textX, this.textY, this.textZ);
    }

    public void text(String string, float f, float f2) {
        int n;
        if (this.textFont == null) {
            this.defaultFontOrDeath("text");
        }
        if ((n = string.length()) > this.textBuffer.length) {
            this.textBuffer = new char[n + 10];
        }
        string.getChars(0, n, this.textBuffer, 0);
        this.text(this.textBuffer, 0, n, f, f2);
    }

    public void text(char[] cArray, int n, int n2, float f, float f2) {
        int n3;
        float f3 = 0.0f;
        for (n3 = n; n3 < n2; ++n3) {
            if (cArray[n3] != '\n') continue;
            f3 += this.textLeading;
        }
        if (this.textAlignY == 3) {
            f2 += (this.textAscent() - f3) / 2.0f;
        } else if (this.textAlignY == 101) {
            f2 += this.textAscent();
        } else if (this.textAlignY == 102) {
            f2 -= this.textDescent() + f3;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            if (cArray[n3] != '\n') continue;
            this.textLineAlignImpl(cArray, n, n3, f, f2);
            n = n3 + 1;
            f2 += this.textLeading;
        }
        if (n < n2) {
            this.textLineAlignImpl(cArray, n, n3, f, f2);
        }
    }

    public void text(String string, float f, float f2, float f3) {
        if (f3 != 0.0f) {
            this.translate(0.0f, 0.0f, f3);
        }
        this.text(string, f, f2);
        this.textZ = f3;
        if (f3 != 0.0f) {
            this.translate(0.0f, 0.0f, -f3);
        }
    }

    public void text(char[] cArray, int n, int n2, float f, float f2, float f3) {
        if (f3 != 0.0f) {
            this.translate(0.0f, 0.0f, f3);
        }
        this.text(cArray, n, n2, f, f2);
        this.textZ = f3;
        if (f3 != 0.0f) {
            this.translate(0.0f, 0.0f, -f3);
        }
    }

    public void text(String string, float f, float f2, float f3, float f4) {
        float f5;
        if (this.textFont == null) {
            this.defaultFontOrDeath("text");
        }
        switch (this.rectMode) {
            case 0: {
                f3 += f;
                f4 += f2;
                break;
            }
            case 2: {
                float f6 = f3;
                float f7 = f4;
                f3 = f + f6;
                f4 = f2 + f7;
                f -= f6;
                f2 -= f7;
                break;
            }
            case 3: {
                float f6 = f3 / 2.0f;
                float f7 = f4 / 2.0f;
                f3 = f + f6;
                f4 = f2 + f7;
                f -= f6;
                f2 -= f7;
            }
        }
        if (f3 < f) {
            f5 = f;
            f = f3;
            f3 = f5;
        }
        if (f4 < f2) {
            f5 = f2;
            f2 = f4;
            f4 = f5;
        }
        f5 = f3 - f;
        float f8 = this.textWidth(' ');
        if (this.textBreakStart == null) {
            this.textBreakStart = new int[20];
            this.textBreakStop = new int[20];
        }
        this.textBreakCount = 0;
        int n = string.length();
        if (n + 1 > this.textBuffer.length) {
            this.textBuffer = new char[n + 1];
        }
        string.getChars(0, n, this.textBuffer, 0);
        this.textBuffer[n++] = 10;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.textBuffer[i] != '\n') continue;
            boolean bl = this.textSentence(this.textBuffer, n2, i, f5, f8);
            if (!bl) break;
            n2 = i + 1;
        }
        float f9 = f;
        if (this.textAlign == 3) {
            f9 += f5 / 2.0f;
        } else if (this.textAlign == 39) {
            f9 = f3;
        }
        float f10 = f4 - f2;
        float f11 = this.textAscent() + this.textDescent();
        int n3 = 1 + PApplet.floor((f10 - f11) / this.textLeading);
        int n4 = Math.min(this.textBreakCount, n3);
        if (this.textAlignY == 3) {
            float f12 = this.textAscent() + this.textLeading * (float)(n4 - 1);
            float f13 = f2 + this.textAscent() + (f10 - f12) / 2.0f;
            for (int i = 0; i < n4; ++i) {
                this.textLineAlignImpl(this.textBuffer, this.textBreakStart[i], this.textBreakStop[i], f9, f13);
                f13 += this.textLeading;
            }
        } else if (this.textAlignY == 102) {
            float f14 = f4 - this.textDescent() - this.textLeading * (float)(n4 - 1);
            for (int i = 0; i < n4; ++i) {
                this.textLineAlignImpl(this.textBuffer, this.textBreakStart[i], this.textBreakStop[i], f9, f14);
                f14 += this.textLeading;
            }
        } else {
            float f15 = f2 + this.textAscent();
            for (int i = 0; i < n4; ++i) {
                this.textLineAlignImpl(this.textBuffer, this.textBreakStart[i], this.textBreakStop[i], f9, f15);
                f15 += this.textLeading;
            }
        }
    }

    protected boolean textSentence(char[] cArray, int n, int n2, float f, float f2) {
        float f3 = 0.0f;
        int n3 = n;
        int n4 = n;
        int n5 = n;
        while (n5 <= n2) {
            if (cArray[n5] == ' ' || n5 == n2) {
                float f4 = this.textWidthImpl(cArray, n4, n5);
                if (f3 + f4 > f) {
                    if (f3 != 0.0f) {
                        this.textSentenceBreak(n3, n5);
                        for (n5 = n4; n5 < n2 && cArray[n5] == ' '; ++n5) {
                        }
                    } else {
                        do {
                            if (--n5 != n4) continue;
                            return false;
                        } while ((f4 = this.textWidthImpl(cArray, n4, n5)) > f);
                        this.textSentenceBreak(n3, n5);
                    }
                    n3 = n5;
                    n4 = n5;
                    f3 = 0.0f;
                    continue;
                }
                if (n5 == n2) {
                    this.textSentenceBreak(n3, n5);
                    ++n5;
                    continue;
                }
                f3 += f4 + f2;
                n4 = n5 + 1;
                ++n5;
                continue;
            }
            ++n5;
        }
        return true;
    }

    protected void textSentenceBreak(int n, int n2) {
        if (this.textBreakCount == this.textBreakStart.length) {
            this.textBreakStart = PApplet.expand(this.textBreakStart);
            this.textBreakStop = PApplet.expand(this.textBreakStop);
        }
        this.textBreakStart[this.textBreakCount] = n;
        this.textBreakStop[this.textBreakCount] = n2;
        ++this.textBreakCount;
    }

    public void text(String string, float f, float f2, float f3, float f4, float f5) {
        if (f5 != 0.0f) {
            this.translate(0.0f, 0.0f, f5);
        }
        this.text(string, f, f2, f3, f4);
        this.textZ = f5;
        if (f5 != 0.0f) {
            this.translate(0.0f, 0.0f, -f5);
        }
    }

    public void text(int n, float f, float f2) {
        this.text(String.valueOf(n), f, f2);
    }

    public void text(int n, float f, float f2, float f3) {
        this.text(String.valueOf(n), f, f2, f3);
    }

    public void text(float f, float f2, float f3) {
        this.text(PApplet.nfs(f, 0, 3), f2, f3);
    }

    public void text(float f, float f2, float f3, float f4) {
        this.text(PApplet.nfs(f, 0, 3), f2, f3, f4);
    }

    protected void textLineAlignImpl(char[] cArray, int n, int n2, float f, float f2) {
        if (this.textAlign == 3) {
            f -= this.textWidthImpl(cArray, n, n2) / 2.0f;
        } else if (this.textAlign == 39) {
            f -= this.textWidthImpl(cArray, n, n2);
        }
        this.textLineImpl(cArray, n, n2, f, f2);
    }

    protected void textLineImpl(char[] cArray, int n, int n2, float f, float f2) {
        for (int i = n; i < n2; ++i) {
            this.textCharImpl(cArray[i], f, f2);
            f += this.textWidth(cArray[i]);
        }
        this.textX = f;
        this.textY = f2;
        this.textZ = 0.0f;
    }

    protected void textCharImpl(char c, float f, float f2) {
        PFont.Glyph glyph = this.textFont.getGlyph(c);
        if (glyph != null) {
            if (this.textMode == 4) {
                float f3 = (float)glyph.height / (float)this.textFont.size;
                float f4 = (float)glyph.width / (float)this.textFont.size;
                float f5 = (float)glyph.leftExtent / (float)this.textFont.size;
                float f6 = (float)glyph.topExtent / (float)this.textFont.size;
                float f7 = f + f5 * this.textSize;
                float f8 = f2 - f6 * this.textSize;
                float f9 = f7 + f4 * this.textSize;
                float f10 = f8 + f3 * this.textSize;
                this.textCharModelImpl(glyph.image, f7, f8, f9, f10, glyph.width, glyph.height);
            }
        } else if (c != ' ' && c != '\u007f') {
            PGraphics.showWarning("No glyph found for the " + c + " (\\u" + PApplet.hex(c, 4) + ") character");
        }
    }

    protected void textCharModelImpl(PImage pImage, float f, float f2, float f3, float f4, int n, int n2) {
        boolean bl = this.tint;
        int n3 = this.tintColor;
        float f5 = this.tintR;
        float f6 = this.tintG;
        float f7 = this.tintB;
        float f8 = this.tintA;
        boolean bl2 = this.tintAlpha;
        this.tint = true;
        this.tintColor = this.fillColor;
        this.tintR = this.fillR;
        this.tintG = this.fillG;
        this.tintB = this.fillB;
        this.tintA = this.fillA;
        this.tintAlpha = this.fillAlpha;
        this.imageImpl(pImage, f, f2, f3, f4, 0, 0, n, n2);
        this.tint = bl;
        this.tintColor = n3;
        this.tintR = f5;
        this.tintG = f6;
        this.tintB = f7;
        this.tintA = f8;
        this.tintAlpha = bl2;
    }

    protected void textCharScreenImpl(PImage pImage, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        if (n >= this.width || n2 >= this.height || n + n3 < 0 || n2 + n4 < 0) {
            return;
        }
        if (n < 0) {
            n5 -= n;
            n3 += n;
            n = 0;
        }
        if (n2 < 0) {
            n6 -= n2;
            n4 += n2;
            n2 = 0;
        }
        if (n + n3 > this.width) {
            n3 -= n + n3 - this.width;
        }
        if (n2 + n4 > this.height) {
            n4 -= n2 + n4 - this.height;
        }
        int n7 = this.fillRi;
        int n8 = this.fillGi;
        int n9 = this.fillBi;
        int n10 = this.fillAi;
        int[] nArray = pImage.pixels;
        for (int i = n6; i < n6 + n4; ++i) {
            for (int j = n5; j < n5 + n3; ++j) {
                int n11 = n10 * nArray[i * pImage.width + j] >> 8;
                int n12 = n11 ^ 0xFF;
                int n13 = this.pixels[(n2 + i - n6) * this.width + (n + j - n5)];
                this.pixels[(n2 + i - n6) * this.width + n + j - n5] = 0xFF000000 | (n11 * n7 + n12 * (n13 >> 16 & 0xFF) & 0xFF00) << 8 | n11 * n8 + n12 * (n13 >> 8 & 0xFF) & 0xFF00 | n11 * n9 + n12 * (n13 & 0xFF) >> 8;
            }
        }
    }

    public void pushMatrix() {
        PGraphics.showMethodWarning("pushMatrix");
    }

    public void popMatrix() {
        PGraphics.showMethodWarning("popMatrix");
    }

    public void translate(float f, float f2) {
        PGraphics.showMissingWarning("translate");
    }

    public void translate(float f, float f2, float f3) {
        PGraphics.showMissingWarning("translate");
    }

    public void rotate(float f) {
        PGraphics.showMissingWarning("rotate");
    }

    public void rotateX(float f) {
        PGraphics.showMethodWarning("rotateX");
    }

    public void rotateY(float f) {
        PGraphics.showMethodWarning("rotateY");
    }

    public void rotateZ(float f) {
        PGraphics.showMethodWarning("rotateZ");
    }

    public void rotate(float f, float f2, float f3, float f4) {
        PGraphics.showMissingWarning("rotate");
    }

    public void scale(float f) {
        PGraphics.showMissingWarning("scale");
    }

    public void scale(float f, float f2) {
        PGraphics.showMissingWarning("scale");
    }

    public void scale(float f, float f2, float f3) {
        PGraphics.showMissingWarning("scale");
    }

    public void shearX(float f) {
        PGraphics.showMissingWarning("shearX");
    }

    public void shearY(float f) {
        PGraphics.showMissingWarning("shearY");
    }

    public void resetMatrix() {
        PGraphics.showMethodWarning("resetMatrix");
    }

    public void applyMatrix(PMatrix pMatrix) {
        if (pMatrix instanceof PMatrix2D) {
            this.applyMatrix((PMatrix2D)pMatrix);
        } else if (pMatrix instanceof PMatrix3D) {
            this.applyMatrix((PMatrix3D)pMatrix);
        }
    }

    public void applyMatrix(PMatrix2D pMatrix2D) {
        this.applyMatrix(pMatrix2D.m00, pMatrix2D.m01, pMatrix2D.m02, pMatrix2D.m10, pMatrix2D.m11, pMatrix2D.m12);
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        PGraphics.showMissingWarning("applyMatrix");
    }

    public void applyMatrix(PMatrix3D pMatrix3D) {
        this.applyMatrix(pMatrix3D.m00, pMatrix3D.m01, pMatrix3D.m02, pMatrix3D.m03, pMatrix3D.m10, pMatrix3D.m11, pMatrix3D.m12, pMatrix3D.m13, pMatrix3D.m20, pMatrix3D.m21, pMatrix3D.m22, pMatrix3D.m23, pMatrix3D.m30, pMatrix3D.m31, pMatrix3D.m32, pMatrix3D.m33);
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        PGraphics.showMissingWarning("applyMatrix");
    }

    public PMatrix getMatrix() {
        PGraphics.showMissingWarning("getMatrix");
        return null;
    }

    public PMatrix2D getMatrix(PMatrix2D pMatrix2D) {
        PGraphics.showMissingWarning("getMatrix");
        return null;
    }

    public PMatrix3D getMatrix(PMatrix3D pMatrix3D) {
        PGraphics.showMissingWarning("getMatrix");
        return null;
    }

    public void setMatrix(PMatrix pMatrix) {
        if (pMatrix instanceof PMatrix2D) {
            this.setMatrix((PMatrix2D)pMatrix);
        } else if (pMatrix instanceof PMatrix3D) {
            this.setMatrix((PMatrix3D)pMatrix);
        }
    }

    public void setMatrix(PMatrix2D pMatrix2D) {
        PGraphics.showMissingWarning("setMatrix");
    }

    public void setMatrix(PMatrix3D pMatrix3D) {
        PGraphics.showMissingWarning("setMatrix");
    }

    public void printMatrix() {
        PGraphics.showMethodWarning("printMatrix");
    }

    public void beginCamera() {
        PGraphics.showMethodWarning("beginCamera");
    }

    public void endCamera() {
        PGraphics.showMethodWarning("endCamera");
    }

    public void camera() {
        PGraphics.showMissingWarning("camera");
    }

    public void camera(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        PGraphics.showMissingWarning("camera");
    }

    public void printCamera() {
        PGraphics.showMethodWarning("printCamera");
    }

    public void ortho() {
        PGraphics.showMissingWarning("ortho");
    }

    public void ortho(float f, float f2, float f3, float f4) {
        PGraphics.showMissingWarning("ortho");
    }

    public void ortho(float f, float f2, float f3, float f4, float f5, float f6) {
        PGraphics.showMissingWarning("ortho");
    }

    public void perspective() {
        PGraphics.showMissingWarning("perspective");
    }

    public void perspective(float f, float f2, float f3, float f4) {
        PGraphics.showMissingWarning("perspective");
    }

    public void frustum(float f, float f2, float f3, float f4, float f5, float f6) {
        PGraphics.showMethodWarning("frustum");
    }

    public void printProjection() {
        PGraphics.showMethodWarning("printCamera");
    }

    public float screenX(float f, float f2) {
        PGraphics.showMissingWarning("screenX");
        return 0.0f;
    }

    public float screenY(float f, float f2) {
        PGraphics.showMissingWarning("screenY");
        return 0.0f;
    }

    public float screenX(float f, float f2, float f3) {
        PGraphics.showMissingWarning("screenX");
        return 0.0f;
    }

    public float screenY(float f, float f2, float f3) {
        PGraphics.showMissingWarning("screenY");
        return 0.0f;
    }

    public float screenZ(float f, float f2, float f3) {
        PGraphics.showMissingWarning("screenZ");
        return 0.0f;
    }

    public float modelX(float f, float f2, float f3) {
        PGraphics.showMissingWarning("modelX");
        return 0.0f;
    }

    public float modelY(float f, float f2, float f3) {
        PGraphics.showMissingWarning("modelY");
        return 0.0f;
    }

    public float modelZ(float f, float f2, float f3) {
        PGraphics.showMissingWarning("modelZ");
        return 0.0f;
    }

    public void pushStyle() {
        if (this.styleStackDepth == this.styleStack.length) {
            this.styleStack = (PStyle[])PApplet.expand(this.styleStack);
        }
        if (this.styleStack[this.styleStackDepth] == null) {
            this.styleStack[this.styleStackDepth] = new PStyle();
        }
        PStyle pStyle = this.styleStack[this.styleStackDepth++];
        this.getStyle(pStyle);
    }

    public void popStyle() {
        if (this.styleStackDepth == 0) {
            throw new RuntimeException("Too many popStyle() without enough pushStyle()");
        }
        --this.styleStackDepth;
        this.style(this.styleStack[this.styleStackDepth]);
    }

    public void style(PStyle pStyle) {
        this.imageMode(pStyle.imageMode);
        this.rectMode(pStyle.rectMode);
        this.ellipseMode(pStyle.ellipseMode);
        this.shapeMode(pStyle.shapeMode);
        if (pStyle.tint) {
            this.tint(pStyle.tintColor);
        } else {
            this.noTint();
        }
        if (pStyle.fill) {
            this.fill(pStyle.fillColor);
        } else {
            this.noFill();
        }
        if (pStyle.stroke) {
            this.stroke(pStyle.strokeColor);
        } else {
            this.noStroke();
        }
        this.strokeWeight(pStyle.strokeWeight);
        this.strokeCap(pStyle.strokeCap);
        this.strokeJoin(pStyle.strokeJoin);
        this.colorMode(1, 1.0f);
        this.ambient(pStyle.ambientR, pStyle.ambientG, pStyle.ambientB);
        this.emissive(pStyle.emissiveR, pStyle.emissiveG, pStyle.emissiveB);
        this.specular(pStyle.specularR, pStyle.specularG, pStyle.specularB);
        this.shininess(pStyle.shininess);
        this.colorMode(pStyle.colorMode, pStyle.colorModeX, pStyle.colorModeY, pStyle.colorModeZ, pStyle.colorModeA);
        if (pStyle.textFont != null) {
            this.textFont(pStyle.textFont, pStyle.textSize);
            this.textLeading(pStyle.textLeading);
        }
        this.textAlign(pStyle.textAlign, pStyle.textAlignY);
        this.textMode(pStyle.textMode);
    }

    public PStyle getStyle() {
        return this.getStyle(null);
    }

    public PStyle getStyle(PStyle pStyle) {
        if (pStyle == null) {
            pStyle = new PStyle();
        }
        pStyle.imageMode = this.imageMode;
        pStyle.rectMode = this.rectMode;
        pStyle.ellipseMode = this.ellipseMode;
        pStyle.shapeMode = this.shapeMode;
        pStyle.colorMode = this.colorMode;
        pStyle.colorModeX = this.colorModeX;
        pStyle.colorModeY = this.colorModeY;
        pStyle.colorModeZ = this.colorModeZ;
        pStyle.colorModeA = this.colorModeA;
        pStyle.tint = this.tint;
        pStyle.tintColor = this.tintColor;
        pStyle.fill = this.fill;
        pStyle.fillColor = this.fillColor;
        pStyle.stroke = this.stroke;
        pStyle.strokeColor = this.strokeColor;
        pStyle.strokeWeight = this.strokeWeight;
        pStyle.strokeCap = this.strokeCap;
        pStyle.strokeJoin = this.strokeJoin;
        pStyle.ambientR = this.ambientR;
        pStyle.ambientG = this.ambientG;
        pStyle.ambientB = this.ambientB;
        pStyle.specularR = this.specularR;
        pStyle.specularG = this.specularG;
        pStyle.specularB = this.specularB;
        pStyle.emissiveR = this.emissiveR;
        pStyle.emissiveG = this.emissiveG;
        pStyle.emissiveB = this.emissiveB;
        pStyle.shininess = this.shininess;
        pStyle.textFont = this.textFont;
        pStyle.textAlign = this.textAlign;
        pStyle.textAlignY = this.textAlignY;
        pStyle.textMode = this.textMode;
        pStyle.textSize = this.textSize;
        pStyle.textLeading = this.textLeading;
        return pStyle;
    }

    public void strokeWeight(float f) {
        this.strokeWeight = f;
    }

    public void strokeJoin(int n) {
        this.strokeJoin = n;
    }

    public void strokeCap(int n) {
        this.strokeCap = n;
    }

    public void noStroke() {
        this.stroke = false;
    }

    public void stroke(int n) {
        this.colorCalc(n);
        this.strokeFromCalc();
    }

    public void stroke(int n, float f) {
        this.colorCalc(n, f);
        this.strokeFromCalc();
    }

    public void stroke(float f) {
        this.colorCalc(f);
        this.strokeFromCalc();
    }

    public void stroke(float f, float f2) {
        this.colorCalc(f, f2);
        this.strokeFromCalc();
    }

    public void stroke(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.strokeFromCalc();
    }

    public void stroke(float f, float f2, float f3, float f4) {
        this.colorCalc(f, f2, f3, f4);
        this.strokeFromCalc();
    }

    protected void strokeFromCalc() {
        this.stroke = true;
        this.strokeR = this.calcR;
        this.strokeG = this.calcG;
        this.strokeB = this.calcB;
        this.strokeA = this.calcA;
        this.strokeRi = this.calcRi;
        this.strokeGi = this.calcGi;
        this.strokeBi = this.calcBi;
        this.strokeAi = this.calcAi;
        this.strokeColor = this.calcColor;
        this.strokeAlpha = this.calcAlpha;
    }

    public void noTint() {
        this.tint = false;
    }

    public void tint(int n) {
        this.colorCalc(n);
        this.tintFromCalc();
    }

    public void tint(int n, float f) {
        this.colorCalc(n, f);
        this.tintFromCalc();
    }

    public void tint(float f) {
        this.colorCalc(f);
        this.tintFromCalc();
    }

    public void tint(float f, float f2) {
        this.colorCalc(f, f2);
        this.tintFromCalc();
    }

    public void tint(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.tintFromCalc();
    }

    public void tint(float f, float f2, float f3, float f4) {
        this.colorCalc(f, f2, f3, f4);
        this.tintFromCalc();
    }

    protected void tintFromCalc() {
        this.tint = true;
        this.tintR = this.calcR;
        this.tintG = this.calcG;
        this.tintB = this.calcB;
        this.tintA = this.calcA;
        this.tintRi = this.calcRi;
        this.tintGi = this.calcGi;
        this.tintBi = this.calcBi;
        this.tintAi = this.calcAi;
        this.tintColor = this.calcColor;
        this.tintAlpha = this.calcAlpha;
    }

    public void noFill() {
        this.fill = false;
    }

    public void fill(int n) {
        this.colorCalc(n);
        this.fillFromCalc();
    }

    public void fill(int n, float f) {
        this.colorCalc(n, f);
        this.fillFromCalc();
    }

    public void fill(float f) {
        this.colorCalc(f);
        this.fillFromCalc();
    }

    public void fill(float f, float f2) {
        this.colorCalc(f, f2);
        this.fillFromCalc();
    }

    public void fill(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.fillFromCalc();
    }

    public void fill(float f, float f2, float f3, float f4) {
        this.colorCalc(f, f2, f3, f4);
        this.fillFromCalc();
    }

    protected void fillFromCalc() {
        this.fill = true;
        this.fillR = this.calcR;
        this.fillG = this.calcG;
        this.fillB = this.calcB;
        this.fillA = this.calcA;
        this.fillRi = this.calcRi;
        this.fillGi = this.calcGi;
        this.fillBi = this.calcBi;
        this.fillAi = this.calcAi;
        this.fillColor = this.calcColor;
        this.fillAlpha = this.calcAlpha;
    }

    public void ambient(int n) {
        this.colorCalc(n);
        this.ambientFromCalc();
    }

    public void ambient(float f) {
        this.colorCalc(f);
        this.ambientFromCalc();
    }

    public void ambient(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.ambientFromCalc();
    }

    protected void ambientFromCalc() {
        this.ambientR = this.calcR;
        this.ambientG = this.calcG;
        this.ambientB = this.calcB;
    }

    public void specular(int n) {
        this.colorCalc(n);
        this.specularFromCalc();
    }

    public void specular(float f) {
        this.colorCalc(f);
        this.specularFromCalc();
    }

    public void specular(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.specularFromCalc();
    }

    protected void specularFromCalc() {
        this.specularR = this.calcR;
        this.specularG = this.calcG;
        this.specularB = this.calcB;
    }

    public void shininess(float f) {
        this.shininess = f;
    }

    public void emissive(int n) {
        this.colorCalc(n);
        this.emissiveFromCalc();
    }

    public void emissive(float f) {
        this.colorCalc(f);
        this.emissiveFromCalc();
    }

    public void emissive(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.emissiveFromCalc();
    }

    protected void emissiveFromCalc() {
        this.emissiveR = this.calcR;
        this.emissiveG = this.calcG;
        this.emissiveB = this.calcB;
    }

    public void lights() {
        PGraphics.showMethodWarning("lights");
    }

    public void noLights() {
        PGraphics.showMethodWarning("noLights");
    }

    public void ambientLight(float f, float f2, float f3) {
        PGraphics.showMethodWarning("ambientLight");
    }

    public void ambientLight(float f, float f2, float f3, float f4, float f5, float f6) {
        PGraphics.showMethodWarning("ambientLight");
    }

    public void directionalLight(float f, float f2, float f3, float f4, float f5, float f6) {
        PGraphics.showMethodWarning("directionalLight");
    }

    public void pointLight(float f, float f2, float f3, float f4, float f5, float f6) {
        PGraphics.showMethodWarning("pointLight");
    }

    public void spotLight(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        PGraphics.showMethodWarning("spotLight");
    }

    public void lightFalloff(float f, float f2, float f3) {
        PGraphics.showMethodWarning("lightFalloff");
    }

    public void lightSpecular(float f, float f2, float f3) {
        PGraphics.showMethodWarning("lightSpecular");
    }

    public void background(int n) {
        this.colorCalc(n);
        this.backgroundFromCalc();
    }

    public void background(int n, float f) {
        this.colorCalc(n, f);
        this.backgroundFromCalc();
    }

    public void background(float f) {
        this.colorCalc(f);
        this.backgroundFromCalc();
    }

    public void background(float f, float f2) {
        if (this.format == 1) {
            this.background(f);
        } else {
            this.colorCalc(f, f2);
            this.backgroundFromCalc();
        }
    }

    public void background(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.backgroundFromCalc();
    }

    public void background(float f, float f2, float f3, float f4) {
        this.colorCalc(f, f2, f3, f4);
        this.backgroundFromCalc();
    }

    protected void backgroundFromCalc() {
        this.backgroundR = this.calcR;
        this.backgroundG = this.calcG;
        this.backgroundB = this.calcB;
        this.backgroundA = this.format == 1 ? this.colorModeA : this.calcA;
        this.backgroundRi = this.calcRi;
        this.backgroundGi = this.calcGi;
        this.backgroundBi = this.calcBi;
        this.backgroundAi = this.format == 1 ? 255 : this.calcAi;
        this.backgroundAlpha = this.format == 1 ? false : this.calcAlpha;
        this.backgroundColor = this.calcColor;
        this.backgroundImpl();
    }

    public void background(PImage pImage) {
        if (pImage.width != this.width || pImage.height != this.height) {
            throw new RuntimeException("background image must be the same size as your application");
        }
        if (pImage.format != 1 && pImage.format != 2) {
            throw new RuntimeException("background images should be RGB or ARGB");
        }
        this.backgroundColor = 0;
        this.backgroundImpl(pImage);
    }

    protected void backgroundImpl(PImage pImage) {
        this.set(0, 0, pImage);
    }

    protected void backgroundImpl() {
        this.pushStyle();
        this.pushMatrix();
        this.resetMatrix();
        this.fill(this.backgroundColor);
        this.rect(0.0f, 0.0f, this.width, this.height);
        this.popMatrix();
        this.popStyle();
    }

    public void colorMode(int n) {
        this.colorMode(n, this.colorModeX, this.colorModeY, this.colorModeZ, this.colorModeA);
    }

    public void colorMode(int n, float f) {
        this.colorMode(n, f, f, f, f);
    }

    public void colorMode(int n, float f, float f2, float f3) {
        this.colorMode(n, f, f2, f3, this.colorModeA);
    }

    public void colorMode(int n, float f, float f2, float f3, float f4) {
        this.colorMode = n;
        this.colorModeX = f;
        this.colorModeY = f2;
        this.colorModeZ = f3;
        this.colorModeA = f4;
        this.colorModeScale = f4 != 1.0f || f != f2 || f2 != f3 || f3 != f4;
        this.colorModeDefault = this.colorMode == 1 && this.colorModeA == 255.0f && this.colorModeX == 255.0f && this.colorModeY == 255.0f && this.colorModeZ == 255.0f;
    }

    protected void colorCalc(int n) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.colorCalc((float)n);
        } else {
            this.colorCalcARGB(n, this.colorModeA);
        }
    }

    protected void colorCalc(int n, float f) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.colorCalc((float)n, f);
        } else {
            this.colorCalcARGB(n, f);
        }
    }

    protected void colorCalc(float f) {
        this.colorCalc(f, this.colorModeA);
    }

    protected void colorCalc(float f, float f2) {
        if (f > this.colorModeX) {
            f = this.colorModeX;
        }
        if (f2 > this.colorModeA) {
            f2 = this.colorModeA;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        this.calcG = this.calcR = this.colorModeScale ? f / this.colorModeX : f;
        this.calcB = this.calcR;
        this.calcA = this.colorModeScale ? f2 / this.colorModeA : f2;
        this.calcRi = (int)(this.calcR * 255.0f);
        this.calcGi = (int)(this.calcG * 255.0f);
        this.calcBi = (int)(this.calcB * 255.0f);
        this.calcAi = (int)(this.calcA * 255.0f);
        this.calcColor = this.calcAi << 24 | this.calcRi << 16 | this.calcGi << 8 | this.calcBi;
        this.calcAlpha = this.calcAi != 255;
    }

    protected void colorCalc(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3, this.colorModeA);
    }

    protected void colorCalc(float f, float f2, float f3, float f4) {
        if (f > this.colorModeX) {
            f = this.colorModeX;
        }
        if (f2 > this.colorModeY) {
            f2 = this.colorModeY;
        }
        if (f3 > this.colorModeZ) {
            f3 = this.colorModeZ;
        }
        if (f4 > this.colorModeA) {
            f4 = this.colorModeA;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        block0 : switch (this.colorMode) {
            case 1: {
                if (this.colorModeScale) {
                    this.calcR = f / this.colorModeX;
                    this.calcG = f2 / this.colorModeY;
                    this.calcB = f3 / this.colorModeZ;
                    this.calcA = f4 / this.colorModeA;
                    break;
                }
                this.calcR = f;
                this.calcG = f2;
                this.calcB = f3;
                this.calcA = f4;
                break;
            }
            case 3: {
                f /= this.colorModeX;
                f3 /= this.colorModeZ;
                float f5 = this.calcA = this.colorModeScale ? f4 / this.colorModeA : f4;
                if ((f2 /= this.colorModeY) == 0.0f) {
                    this.calcG = this.calcB = f3;
                    this.calcR = this.calcB;
                    break;
                }
                float f6 = (f - (float)((int)f)) * 6.0f;
                float f7 = f6 - (float)((int)f6);
                float f8 = f3 * (1.0f - f2);
                float f9 = f3 * (1.0f - f2 * f7);
                float f10 = f3 * (1.0f - f2 * (1.0f - f7));
                switch ((int)f6) {
                    case 0: {
                        this.calcR = f3;
                        this.calcG = f10;
                        this.calcB = f8;
                        break block0;
                    }
                    case 1: {
                        this.calcR = f9;
                        this.calcG = f3;
                        this.calcB = f8;
                        break block0;
                    }
                    case 2: {
                        this.calcR = f8;
                        this.calcG = f3;
                        this.calcB = f10;
                        break block0;
                    }
                    case 3: {
                        this.calcR = f8;
                        this.calcG = f9;
                        this.calcB = f3;
                        break block0;
                    }
                    case 4: {
                        this.calcR = f10;
                        this.calcG = f8;
                        this.calcB = f3;
                        break block0;
                    }
                    case 5: {
                        this.calcR = f3;
                        this.calcG = f8;
                        this.calcB = f9;
                    }
                }
            }
        }
        this.calcRi = (int)(255.0f * this.calcR);
        this.calcGi = (int)(255.0f * this.calcG);
        this.calcBi = (int)(255.0f * this.calcB);
        this.calcAi = (int)(255.0f * this.calcA);
        this.calcColor = this.calcAi << 24 | this.calcRi << 16 | this.calcGi << 8 | this.calcBi;
        this.calcAlpha = this.calcAi != 255;
    }

    protected void colorCalcARGB(int n, float f) {
        if (f == this.colorModeA) {
            this.calcAi = n >> 24 & 0xFF;
            this.calcColor = n;
        } else {
            this.calcAi = (int)((float)(n >> 24 & 0xFF) * (f / this.colorModeA));
            this.calcColor = this.calcAi << 24 | n & 0xFFFFFF;
        }
        this.calcRi = n >> 16 & 0xFF;
        this.calcGi = n >> 8 & 0xFF;
        this.calcBi = n & 0xFF;
        this.calcA = (float)this.calcAi / 255.0f;
        this.calcR = (float)this.calcRi / 255.0f;
        this.calcG = (float)this.calcGi / 255.0f;
        this.calcB = (float)this.calcBi / 255.0f;
        this.calcAlpha = this.calcAi != 255;
    }

    public final int color(int n) {
        this.colorCalc(n);
        return this.calcColor;
    }

    public final int color(float f) {
        this.colorCalc(f);
        return this.calcColor;
    }

    public final int color(int n, int n2) {
        this.colorCalc(n, (float)n2);
        return this.calcColor;
    }

    public final int color(int n, float f) {
        this.colorCalc(n, f);
        return this.calcColor;
    }

    public final int color(float f, float f2) {
        this.colorCalc(f, f2);
        return this.calcColor;
    }

    public final int color(int n, int n2, int n3) {
        this.colorCalc(n, n2, n3);
        return this.calcColor;
    }

    public final int color(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        return this.calcColor;
    }

    public final int color(int n, int n2, int n3, int n4) {
        this.colorCalc(n, n2, n3, n4);
        return this.calcColor;
    }

    public final int color(float f, float f2, float f3, float f4) {
        this.colorCalc(f, f2, f3, f4);
        return this.calcColor;
    }

    public final float alpha(int n) {
        float f = n >> 24 & 0xFF;
        if (this.colorModeA == 255.0f) {
            return f;
        }
        return f / 255.0f * this.colorModeA;
    }

    public final float red(int n) {
        float f = n >> 16 & 0xFF;
        if (this.colorModeDefault) {
            return f;
        }
        return f / 255.0f * this.colorModeX;
    }

    public final float green(int n) {
        float f = n >> 8 & 0xFF;
        if (this.colorModeDefault) {
            return f;
        }
        return f / 255.0f * this.colorModeY;
    }

    public final float blue(int n) {
        float f = n & 0xFF;
        if (this.colorModeDefault) {
            return f;
        }
        return f / 255.0f * this.colorModeZ;
    }

    public final float hue(int n) {
        if (n != this.cacheHsbKey) {
            Color.RGBtoHSB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, this.cacheHsbValue);
            this.cacheHsbKey = n;
        }
        return this.cacheHsbValue[0] * this.colorModeX;
    }

    public final float saturation(int n) {
        if (n != this.cacheHsbKey) {
            Color.RGBtoHSB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, this.cacheHsbValue);
            this.cacheHsbKey = n;
        }
        return this.cacheHsbValue[1] * this.colorModeY;
    }

    public final float brightness(int n) {
        if (n != this.cacheHsbKey) {
            Color.RGBtoHSB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, this.cacheHsbValue);
            this.cacheHsbKey = n;
        }
        return this.cacheHsbValue[2] * this.colorModeZ;
    }

    public int lerpColor(int n, int n2, float f) {
        return PGraphics.lerpColor(n, n2, f, this.colorMode);
    }

    public static int lerpColor(int n, int n2, float f, int n3) {
        if (n3 == 1) {
            float f2 = n >> 24 & 0xFF;
            float f3 = n >> 16 & 0xFF;
            float f4 = n >> 8 & 0xFF;
            float f5 = n & 0xFF;
            float f6 = n2 >> 24 & 0xFF;
            float f7 = n2 >> 16 & 0xFF;
            float f8 = n2 >> 8 & 0xFF;
            float f9 = n2 & 0xFF;
            return (int)(f2 + (f6 - f2) * f) << 24 | (int)(f3 + (f7 - f3) * f) << 16 | (int)(f4 + (f8 - f4) * f) << 8 | (int)(f5 + (f9 - f5) * f);
        }
        if (n3 == 3) {
            if (lerpColorHSB1 == null) {
                lerpColorHSB1 = new float[3];
                lerpColorHSB2 = new float[3];
            }
            float f10 = n >> 24 & 0xFF;
            float f11 = n2 >> 24 & 0xFF;
            int n4 = (int)(f10 + (f11 - f10) * f) << 24;
            Color.RGBtoHSB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, lerpColorHSB1);
            Color.RGBtoHSB(n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF, lerpColorHSB2);
            float f12 = PApplet.lerp(lerpColorHSB1[0], lerpColorHSB2[0], f);
            float f13 = PApplet.lerp(lerpColorHSB1[1], lerpColorHSB2[1], f);
            float f14 = PApplet.lerp(lerpColorHSB1[2], lerpColorHSB2[2], f);
            return n4 | Color.HSBtoRGB(f12, f13, f14) & 0xFFFFFF;
        }
        return 0;
    }

    public void beginRaw(PGraphics pGraphics) {
        this.raw = pGraphics;
        pGraphics.beginDraw();
    }

    public void endRaw() {
        if (this.raw != null) {
            this.flush();
            this.raw.endDraw();
            this.raw.dispose();
            this.raw = null;
        }
    }

    public static void showWarning(String string) {
        if (warnings == null) {
            warnings = new HashMap();
        }
        if (!warnings.containsKey(string)) {
            System.err.println(string);
            warnings.put(string, new Object());
        }
    }

    public static void showDepthWarning(String string) {
        PGraphics.showWarning(string + "() can only be used with a renderer that " + "supports 3D, such as P3D or OPENGL.");
    }

    public static void showDepthWarningXYZ(String string) {
        PGraphics.showWarning(string + "() with x, y, and z coordinates " + "can only be used with a renderer that " + "supports 3D, such as P3D or OPENGL. " + "Use a version without a z-coordinate instead.");
    }

    public static void showMethodWarning(String string) {
        PGraphics.showWarning(string + "() is not available with this renderer.");
    }

    public static void showVariationWarning(String string) {
        PGraphics.showWarning(string + " is not available with this renderer.");
    }

    public static void showMissingWarning(String string) {
        PGraphics.showWarning(string + "(), or this particular variation of it, " + "is not available with this renderer.");
    }

    public static void showException(String string) {
        throw new RuntimeException(string);
    }

    protected void defaultFontOrDeath(String string) {
        this.defaultFontOrDeath(string, 12.0f);
    }

    protected void defaultFontOrDeath(String string, float f) {
        if (this.parent == null) {
            throw new RuntimeException("Use textFont() before " + string + "()");
        }
        this.textFont = this.parent.createDefaultFont(f);
    }

    public boolean displayable() {
        return true;
    }

    public boolean is2D() {
        return true;
    }

    public boolean is3D() {
        return false;
    }

    public PShape createGroup() {
        PGraphics.showMissingWarning("createGroup");
        return null;
    }

    public PShape createGeometry(int n) {
        PGraphics.showMissingWarning("createGeometry");
        return null;
    }

    protected String[] getSupportedShapeFormats() {
        PGraphics.showMissingWarning("getSupportedShapeFormats");
        return null;
    }

    protected PShape loadShape(String string, Object object) {
        PGraphics.showMissingWarning("loadShape");
        return null;
    }

    public void screenBlend(int n) {
        PGraphics.showMissingWarning("screenBlend");
    }

    public void textureBlend(int n) {
        PGraphics.showMissingWarning("textureBlend");
    }

    public PShape beginRecord() {
        PGraphics.showMissingWarning("beginRecord");
        return null;
    }

    public void endRecord() {
        PGraphics.showMissingWarning("endRecord");
    }

    public boolean isRecordingShape() {
        return false;
    }

    public void mergeShapes(boolean bl) {
        PGraphics.showMissingWarning("mergeShapes");
    }

    public void shapeName(String string) {
        PGraphics.showMissingWarning("shapeName");
    }

    public void autoNormal(boolean bl) {
        this.autoNormal = bl;
    }

    public void matrixMode(int n) {
        PGraphics.showMissingWarning("matrixMode");
    }

    public void beginText() {
        PGraphics.showMissingWarning("beginText");
    }

    public void endText() {
        PGraphics.showMissingWarning("endText");
    }

    public void texture(PImage ... pImageArray) {
        PGraphics.showMissingWarning("texture");
    }

    static {
        for (int i = 0; i < 720; ++i) {
            PGraphics.sinLUT[i] = (float)Math.sin((float)i * ((float)Math.PI / 180) * 0.5f);
            PGraphics.cosLUT[i] = (float)Math.cos((float)i * ((float)Math.PI / 180) * 0.5f);
        }
    }
}

