/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import processing.core.PApplet;

public class XML
implements Serializable {
    protected Node node;
    protected String name;
    protected XML parent;
    protected XML[] children;

    protected XML() {
    }

    public XML(PApplet pApplet, String string) {
        this(pApplet.createReader(string));
    }

    public XML(Reader reader) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            documentBuilderFactory.setExpandEntityReferences(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(reader));
            this.node = document.getDocumentElement();
            this.name = this.node.getNodeName();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    public XML(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            this.node = document.createElement(string);
            this.name = string;
            this.parent = null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
    }

    protected XML(XML xML, Node node) {
        this.node = node;
        this.parent = xML;
        if (node.getNodeType() == 1) {
            this.name = node.getNodeName();
        }
    }

    public static XML parse(String string) {
        return new XML(new StringReader(string));
    }

    public XML getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalName() {
        return this.node.getLocalName();
    }

    protected void checkChildren() {
        if (this.children == null) {
            NodeList nodeList = this.node.getChildNodes();
            int n = nodeList.getLength();
            this.children = new XML[n];
            for (int i = 0; i < n; ++i) {
                this.children[i] = new XML(this, nodeList.item(i));
            }
        }
    }

    public int getChildCount() {
        this.checkChildren();
        return this.children.length;
    }

    public String[] listChildren() {
        this.checkChildren();
        String[] stringArray = new String[this.children.length];
        for (int i = 0; i < this.children.length; ++i) {
            stringArray[i] = this.children[i].getName();
        }
        return stringArray;
    }

    public XML[] getChildren() {
        this.checkChildren();
        return this.children;
    }

    public XML getChild(int n) {
        this.checkChildren();
        return this.children[n];
    }

    public XML getChild(String string) {
        if (string.indexOf(47) != -1) {
            return this.getChildRecursive(PApplet.split(string, '/'), 0);
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            XML xML = this.getChild(i);
            String string2 = xML.getName();
            if (string2 == null || !string2.equals(string)) continue;
            return xML;
        }
        return null;
    }

    protected XML getChildRecursive(String[] stringArray, int n) {
        if (Character.isDigit(stringArray[n].charAt(0))) {
            XML xML = this.getChild(Integer.parseInt(stringArray[n]));
            if (n == stringArray.length - 1) {
                return xML;
            }
            return xML.getChildRecursive(stringArray, n + 1);
        }
        int n2 = this.getChildCount();
        for (int i = 0; i < n2; ++i) {
            XML xML = this.getChild(i);
            String string = xML.getName();
            if (string == null || !string.equals(stringArray[n])) continue;
            if (n == stringArray.length - 1) {
                return xML;
            }
            return xML.getChildRecursive(stringArray, n + 1);
        }
        return null;
    }

    public XML[] getChildren(String string) {
        if (string.indexOf(47) != -1) {
            return this.getChildrenRecursive(PApplet.split(string, '/'), 0);
        }
        if (Character.isDigit(string.charAt(0))) {
            return new XML[]{this.getChild(Integer.parseInt(string))};
        }
        int n = this.getChildCount();
        XML[] xMLArray = new XML[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            XML xML = this.getChild(i);
            String string2 = xML.getName();
            if (string2 == null || !string2.equals(string)) continue;
            xMLArray[n2++] = xML;
        }
        return (XML[])PApplet.subset(xMLArray, 0, n2);
    }

    protected XML[] getChildrenRecursive(String[] stringArray, int n) {
        if (n == stringArray.length - 1) {
            return this.getChildren(stringArray[n]);
        }
        XML[] xMLArray = this.getChildren(stringArray[n]);
        XML[] xMLArray2 = new XML[]{};
        for (int i = 0; i < xMLArray.length; ++i) {
            XML[] xMLArray3 = xMLArray[i].getChildrenRecursive(stringArray, n + 1);
            xMLArray2 = (XML[])PApplet.concat(xMLArray2, xMLArray3);
        }
        return xMLArray2;
    }

    public XML addChild(String string) {
        Document document = this.node.getOwnerDocument();
        Element element = document.createElement(string);
        this.node.appendChild(element);
        XML xML = new XML(this, element);
        if (this.children != null) {
            this.children = (XML[])PApplet.concat(this.children, new XML[]{xML});
        }
        return xML;
    }

    public void removeChild(XML xML) {
        this.node.removeChild(xML.node);
        this.children = null;
    }

    public int getAttributeCount() {
        return this.node.getAttributes().getLength();
    }

    public String[] listAttributes() {
        NamedNodeMap namedNodeMap = this.node.getAttributes();
        String[] stringArray = new String[namedNodeMap.getLength()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = namedNodeMap.item(i).getNodeName();
        }
        return stringArray;
    }

    public boolean hasAttribute(String string) {
        return this.node.getAttributes().getNamedItem(string) != null;
    }

    public String getString(String string) {
        return this.getString(string, null);
    }

    public String getString(String string, String string2) {
        Node node = this.node.getAttributes().getNamedItem(string);
        return node == null ? string2 : node.getNodeValue();
    }

    public void setString(String string, String string2) {
        ((Element)this.node).setAttribute(string, string2);
    }

    public int getInt(String string) {
        return this.getInt(string, 0);
    }

    public void setInt(String string, int n) {
        this.setString(string, String.valueOf(n));
    }

    public int getInt(String string, int n) {
        String string2 = this.getString(string);
        return string2 == null ? n : Integer.parseInt(string2);
    }

    public float getFloat(String string) {
        return this.getFloat(string, 0.0f);
    }

    public float getFloat(String string, float f) {
        String string2 = this.getString(string);
        return string2 == null ? f : Float.parseFloat(string2);
    }

    public void setFloat(String string, float f) {
        this.setString(string, String.valueOf(f));
    }

    public double getDouble(String string) {
        return this.getDouble(string, 0.0);
    }

    public double getDouble(String string, double d) {
        String string2 = this.getString(string);
        return string2 == null ? d : Double.parseDouble(string2);
    }

    public void setDouble(String string, double d) {
        this.setString(string, String.valueOf(d));
    }

    public String getContent() {
        return this.node.getTextContent();
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int n) {
        try {
            DOMSource dOMSource = new DOMSource(this.node);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            if (this.parent != null) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF8");
            if (n != 0) {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(n));
                transformer.setOutputProperty("indent", "yes");
            }
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

